/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister;

import ch.rinn.restrictions.Friend;
import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.db.mapper.LongSetMapper;
import ch.systemsx.cisd.common.db.mapper.StringArrayMapper;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.GenericEntityPropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IPropertyListingQuery;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.MaterialEntityPropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.VocabularyTermRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.entity.ExperimentProjectSpaceCodeRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.common.MetaProjectWithEntityId;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.SampleRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.SampleRelationRecord;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.DataIterator;
import net.lemnik.eodsql.EoDException;
import net.lemnik.eodsql.Select;
import net.lemnik.eodsql.TypeMapper;
import net.lemnik.eodsql.spi.util.NonUpdateCapableDataObjectBinding;

@Friend(toClasses={ExperimentProjectSpaceCodeRecord.class})
@Private
public interface ISampleListingQuery
extends BaseQuery,
IPropertyListingQuery {
    public static final int FETCH_SIZE = 1000;
    public static final String SELECT_FROM_SAMPLES_S = "           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s";

    @Select(sql="select count(*) from samples s left join spaces g on s.space_id=g.id where s.dbin_id=?{1} or g.dbin_id=?{1}")
    public long getSampleCount(long var1);

    @Select(sql="select * from relationship_types where code=?{1} and is_internal_namespace=?{2}")
    public long getRelationshipTypeId(String var1, boolean var2);

    @Select(sql="SELECT sample_id_child FROM sample_relationships     WHERE relationship_id=?{1} AND sample_id_parent = any(?{2})", parameterBindings={TypeMapper.class, LongSetMapper.class}, fetchSize=1000)
    public DataIterator<Long> getChildrenIds(long var1, LongSet var3);

    @Select(sql="SELECT sample_id_parent FROM sample_relationships     WHERE relationship_id=?{1} AND sample_id_child = any(?{2})", parameterBindings={TypeMapper.class, LongSetMapper.class}, fetchSize=1000)
    public DataIterator<Long> getParentIds(long var1, LongSet var3);

    @Select(sql="SELECT * FROM sample_relationships     WHERE relationship_id=?{1} AND sample_id_child = any(?{2})", parameterBindings={TypeMapper.class, LongSetMapper.class}, fetchSize=1000)
    public DataIterator<SampleRelationRecord> getParentRelations(long var1, LongSet var3);

    @Select(sql="SELECT * FROM sample_relationships     WHERE relationship_id=?{1} AND sample_id_parent = any(?{2})", parameterBindings={TypeMapper.class, LongSetMapper.class}, fetchSize=1000)
    public DataIterator<SampleRelationRecord> getChildrenRelations(long var1, LongSet var3);

    @Select(sql="select id, saty_id, space_id, dbin_id, expe_id from samples", fetchSize=1000)
    public DataIterator<SampleRecord> getSampleSkeletons();

    @Select(sql="select * from sample_relationships", fetchSize=1000)
    public DataIterator<SampleRelationRecord> getSampleRelationshipSkeletons();

    @Select(sql="select p.samp_id from sample_properties as p join samples_all as s on p.samp_id = s.id where s.del_id is null and p.mate_prop_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<Long> getSampleIdsByMaterialProperties(LongSet var1);

    @Select(value="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s where s.id=?{1}")
    public SampleRecord getSample(long var1);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s left join spaces g on s.space_id=g.id where s.dbin_id=?{1} or g.dbin_id=?{1}", fetchSize=1000)
    public DataIterator<SampleRecord> getSamples(long var1);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s join sample_types st on s.saty_id=st.id join spaces g on s.space_id=g.id  where st.is_listable and g.dbin_id=?{1} and g.code=?{2} order by s.code", fetchSize=1000)
    public DataIterator<SampleRecord> getListableSpaceSamples(long var1, String var3);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s join spaces g on s.space_id=g.id  where s.expe_id is not null and g.dbin_id=?{1} and g.code=?{2}  order by s.code", fetchSize=1000)
    public DataIterator<SampleRecord> getSpaceSamplesWithExperiment(long var1, String var3);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s join spaces g on s.space_id=g.id   where g.dbin_id=?{1} and g.code=?{2} and s.saty_id=?{3}        order by s.code", fetchSize=1000)
    public DataIterator<SampleRecord> getSpaceSamplesForSampleType(long var1, String var3, long var4);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s join spaces g on s.space_id=g.id  where s.expe_id is not null and g.dbin_id=?{1} and g.code=?{2} and s.saty_id=?{3}  order by s.code", fetchSize=1000)
    public DataIterator<SampleRecord> getSpaceSamplesForSampleTypeWithExperiment(long var1, String var3, long var4);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s join sample_types st on s.saty_id=st.id join spaces g on s.space_id=g.id  where st.is_listable and g.dbin_id=?{1} order by s.code", fetchSize=1000)
    public DataIterator<SampleRecord> getAllListableSpaceSamples(long var1);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s join spaces g on s.space_id=g.id  where s.expe_id is not null and g.dbin_id=?{1}                  order by s.code", fetchSize=1000)
    public DataIterator<SampleRecord> getAllSpaceSamplesWithExperiment(long var1);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s join spaces g on s.space_id=g.id  where g.dbin_id=?{1} and s.saty_id=?{2}                         order by s.code", fetchSize=1000, rubberstamp=true)
    public DataIterator<SampleRecord> getAllSpaceSamplesForSampleType(long var1, long var3);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s join spaces g on s.space_id=g.id  where s.expe_id is not null and g.dbin_id=?{1} and s.saty_id=?{2}  order by s.code", fetchSize=1000)
    public DataIterator<SampleRecord> getAllSpaceSamplesForSampleTypeWithExperiment(long var1, long var3);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s JOIN sample_types st ON s.saty_id=st.id WHERE st.is_listable AND s.expe_id=?{1}", fetchSize=1000)
    public DataIterator<SampleRecord> getListableSamplesForExperiment(long var1);

    @Select(sql="with recursive connected_samples as (select s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.del_id, s.samp_id_part_of from samples as s join sample_types as st on s.saty_id = st.id where st.is_listable and s.expe_id = ?{1} union select s2.id, s2.perm_id, s2.code, s2.expe_id, s2.space_id, s2.saty_id, s2.dbin_id,     s2.registration_timestamp, s2.modification_timestamp, s2.pers_id_registerer,     s2.del_id, s2.samp_id_part_of from connected_samples as s left join sample_relationships as sr on sr.sample_id_parent = s.id left join samples as s2 on s2.id = sr.sample_id_child join sample_types as st on s2.saty_id = st.id where st.is_listable) select * from connected_samples")
    public DataIterator<SampleRecord> getListableSamplesAndDescendentsForExperiment(long var1);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s where s.samp_id_part_of=any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<SampleRecord> getSamplesForContainer(LongSet var1);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s WHERE s.id IN      (SELECT sample_id_child FROM sample_relationships       WHERE relationship_id=?{1} AND sample_id_parent=?{2})", fetchSize=1000)
    public DataIterator<SampleRecord> getChildrenSamplesForParent(long var1, long var3);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s WHERE s.id IN      (SELECT sample_id_parent FROM sample_relationships       WHERE relationship_id=?{1} AND sample_id_child = any(?{2}))", parameterBindings={TypeMapper.class, LongSetMapper.class}, fetchSize=1000)
    public DataIterator<SampleRecord> getParentSamplesForChildren(long var1, LongSet var3);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s JOIN metaproject_assignments ma ON s.id=ma.samp_id WHERE ma.mepr_id=?{1}", fetchSize=1000)
    public DataIterator<SampleRecord> getSamplesForMetaproject(long var1);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s where s.saty_id=?{1} and s.id in (       select samp_id from sample_properties sp where sp.stpt_id in (              select id from sample_type_property_types stpt where stpt.prty_id =                      (select id from property_types where code=?{2})              ) and value=?{3}                                             ) and not id = any(?{4})", parameterBindings={TypeMapper.class, TypeMapper.class, TypeMapper.class, LongSetMapper.class}, fetchSize=1000)
    public DataIterator<SampleRecord> getSamplesWithPropertyValue(long var1, String var3, String var4, LongSet var5);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s join sample_types st on s.saty_id=st.id    where st.is_listable and s.dbin_id=?{1} order by s.code", fetchSize=1000)
    public DataIterator<SampleRecord> getListableSharedSamples(long var1);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s where s.dbin_id=?{1} and s.saty_id=?{2} order by s.code", fetchSize=1000)
    public DataIterator<SampleRecord> getSharedSamplesForSampleType(long var1, long var3);

    @Select(sql="select id, code, generated_from_depth, part_of_depth from sample_types      where code=?{2} and dbin_id=?{1}", resultSetBinding=SampleTypeDataObjectBinding.class)
    public SampleType getSampleType(long var1, String var3);

    @Select(sql="select id, code, generated_from_depth, part_of_depth from sample_types where dbin_id=?{1}", resultSetBinding=SampleTypeDataObjectBinding.class)
    public SampleType[] getSampleTypes(long var1);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s where s.id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<SampleRecord> getSamples(LongSet var1);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s where s.code = any(?{1})", parameterBindings={StringArrayMapper.class}, fetchSize=1000)
    public DataIterator<SampleRecord> getSamplesForCodes(String[] var1);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s where s.id in (select samp_id_part_of from samples where samp_id_part_of in (select id from samples where code = any(?{1})))", parameterBindings={StringArrayMapper.class}, fetchSize=1000)
    public DataIterator<SampleRecord> getContainerSamplesForCodes(String[] var1);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s where s.perm_id = any(?{1})", parameterBindings={StringArrayMapper.class}, fetchSize=1000)
    public DataIterator<SampleRecord> getSamplesForPermIds(String[] var1);

    @Select(sql="           SELECT s.id, s.perm_id, s.code, s.expe_id, s.space_id, s.saty_id, s.dbin_id,    s.registration_timestamp, s.modification_timestamp, s.pers_id_registerer,    s.pers_id_modifier, s.del_id, s.samp_id_part_of, s.version                                               FROM samples s where s.id in (select samp_id_part_of from samples where samp_id_part_of in (select id from samples where permId = any(?{1})))", parameterBindings={StringArrayMapper.class}, fetchSize=1000)
    public DataIterator<SampleRecord> getContainerSamplesForPermIds(String[] var1);

    @Select(sql="SELECT sp.samp_id as entity_id, stpt.prty_id, stpt.script_id, stpt.ordinal, sp.value, sc.script_type       FROM sample_properties sp      JOIN sample_type_property_types stpt ON sp.stpt_id=stpt.id      LEFT OUTER JOIN scripts sc ON stpt.script_id = sc.id     WHERE sp.value is not null AND sp.samp_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<GenericEntityPropertyRecord> getEntityPropertyGenericValues(LongSet var1);

    @Select(sql="SELECT sp.samp_id as entity_id, stpt.prty_id, stpt.script_id, stpt.ordinal,            cvte.id, cvte.covo_id, cvte.code, cvte.label, cvte.ordinal as term_ordinal, cvte.is_official, cvte.description      FROM sample_properties sp      JOIN sample_type_property_types stpt ON sp.stpt_id=stpt.id      JOIN controlled_vocabulary_terms cvte ON sp.cvte_id=cvte.id     WHERE sp.cvte_id is not null AND sp.samp_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<VocabularyTermRecord> getEntityPropertyVocabularyTermValues(LongSet var1);

    @Select(sql="SELECT sp.samp_id as entity_id, stpt.prty_id, stpt.script_id, stpt.ordinal, m.id, m.code, m.maty_id      FROM sample_properties sp      JOIN sample_type_property_types stpt ON sp.stpt_id=stpt.id      JOIN materials m ON sp.mate_prop_id=m.id      WHERE sp.mate_prop_id is not null AND sp.samp_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<MaterialEntityPropertyRecord> getEntityPropertyMaterialValues(LongSet var1);

    @Select(sql="select m.id as id, m.name as name, m.description as description, p.user_id as owner_name,  m.private as is_private, m.creation_date as creation_date, ma.samp_id as entity_id  from metaprojects m, metaproject_assignments ma, persons p  where ma.samp_id = any(?{1}) and m.owner = ?{2} and m.id = ma.mepr_id and m.owner = p.id", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<MetaProjectWithEntityId> getMetaprojects(LongSet var1, Long var2);

    public static class SampleTypeDataObjectBinding
    extends NonUpdateCapableDataObjectBinding<SampleType> {
        public void unmarshall(ResultSet row, SampleType into) throws SQLException, EoDException {
            into.setId(row.getLong("id"));
            into.setCode(row.getString("code"));
            into.setGeneratedFromHierarchyDepth(row.getInt("generated_from_depth"));
            into.setShowContainer(row.getInt("part_of_depth") > 0);
        }
    }
}

