/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.util;

import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IAuthSession;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.Date;

public class RelationshipUtils {
    public static void setSampleForDataSet(DataPE dataSet, SamplePE sample, IAuthSession session) {
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)dataSet.tryGetSample(), session);
        dataSet.setSample(sample);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, session);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)dataSet, session);
    }

    public static void setContainerForSample(SamplePE sample, SamplePE container, IAuthSession session) {
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample.getContainer(), session);
        sample.setContainer(container);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)container, session);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, session);
    }

    public static void setExperimentForDataSet(DataPE dataSet, ExperimentPE experiment, IAuthSession session) {
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)dataSet.getExperiment(), session);
        dataSet.setExperiment(experiment);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)experiment, session);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)dataSet, session);
    }

    public static void updateModificationDateAndModifier(IModifierAndModificationDateBean beanOrNull, IAuthSession session) {
        if (beanOrNull == null) {
            return;
        }
        RelationshipUtils.log(beanOrNull, session);
        PersonPE person = session.tryGetPerson();
        RelationshipUtils.updateModificationDateAndModifier(beanOrNull, person);
    }

    public static void updateModificationDateAndModifier(IModifierAndModificationDateBean beanOrNull, PersonPE personOrNull) {
        if (personOrNull != null) {
            beanOrNull.setModifier(personOrNull);
        }
        beanOrNull.setModificationDate(new Date());
    }

    private static void log(IModifierAndModificationDateBean beanOrNull, IAuthSession session) {
        StackTraceElement[] stackTrace;
        StackTraceElement[] stackTraceElementArray = stackTrace = Thread.currentThread().getStackTrace();
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            if (stackTraceElement.getClassName().contains("OptimisticLockingTest")) {
                System.out.println("===== UPDATE modification date and modifier ===== " + stackTraceElement.getMethodName());
                System.out.println("bean: " + beanOrNull);
                System.out.println("user: " + session.tryGetPerson());
                System.out.println("\t" + stackTrace[3]);
                System.out.println("\t" + stackTrace[4]);
                System.out.println("\t" + stackTrace[5]);
                System.out.println("\t...");
                System.out.println("\t" + stackTraceElement);
                break;
            }
            ++n2;
        }
    }
}

