/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.importer;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import ch.systemsx.cisd.dbmigration.DatabaseDefinition;
import ch.systemsx.cisd.dbmigration.IDAOFactory;
import ch.systemsx.cisd.dbmigration.IDatabaseAdminDAO;
import ch.systemsx.cisd.dbmigration.SimpleDatabaseMetaData;
import ch.systemsx.cisd.dbmigration.SimpleTableMetaData;
import ch.systemsx.cisd.dbmigration.TableColumnDefinition;
import ch.systemsx.cisd.dbmigration.TableDefinition;
import ch.systemsx.cisd.dbmigration.postgresql.DumpPreparator;
import ch.systemsx.cisd.openbis.generic.server.business.importer.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.server.business.importer.IDatabaseDumper;
import ch.systemsx.cisd.openbis.generic.server.business.importer.Parameters;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.SequenceNameMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class DatabaseInstanceImporter {
    private static final String COLUMN_CODE = "code";
    private static final String COLUMN_UUID = "uuid";
    private static final String COLUMN_IS_ORIGINAL_SOURCE = "is_original_source";
    private static final String DATABASE_INSTANCES = "database_instances";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DatabaseInstanceImporter.class);
    private final File importedDumpFile;
    private final File uploadFolder;
    private final String codeForImportedDatabaseInstanceOrNull;
    private final File currentDumpFile;
    private final File currentDatabaseFolder;
    private final File importDatabaseFolder;
    private IDatabaseAdminDAO exportDAO;
    private IDatabaseAdminDAO uploadDAO;
    private final IDatabaseDumper databaseDumper;

    private static IDatabaseAdminDAO createExportDAO(Parameters parameters) {
        DatabaseConfigurationContext configContext = DatabaseInstanceImporter.createConfigContext(parameters);
        configContext.setUrlHostPart(parameters.getDatabaseName());
        return configContext.createDAOFactory().getDatabaseDAO();
    }

    private static IDatabaseAdminDAO createUploadDAO(Parameters parameters) {
        DatabaseConfigurationContext configContext = DatabaseInstanceImporter.createConfigContext(parameters);
        configContext.setSequenceNameMapper(new SequenceNameMapper());
        configContext.setSequenceUpdateNeeded(true);
        IDAOFactory daoFactory = configContext.createDAOFactory();
        return daoFactory.getDatabaseDAO();
    }

    @Private
    static DatabaseConfigurationContext createConfigContext(Parameters parameters) {
        DatabaseConfigurationContext dbContext = new DatabaseConfigurationContext();
        String databaseName = parameters.getDatabaseName();
        int indexOfDelimiter = databaseName.indexOf(95);
        if (indexOfDelimiter < 0) {
            throw new UserFailureException("Missing '_' in database name '" + databaseName + "'.");
        }
        dbContext.setBasicDatabaseName(databaseName.substring(0, indexOfDelimiter));
        dbContext.setDatabaseKind(databaseName.substring(indexOfDelimiter + 1));
        dbContext.setDatabaseEngineCode(parameters.getDatabaseEngine());
        return dbContext;
    }

    DatabaseInstanceImporter(Parameters parameters) {
        this(parameters, DatabaseInstanceImporter.createExportDAO(parameters), DatabaseInstanceImporter.createUploadDAO(parameters), new IDatabaseDumper(){

            @Override
            public final boolean createDatabaseDump(String dataBaseName, File dumpFile) {
                return DumpPreparator.createDatabaseDump(dataBaseName, dumpFile);
            }
        });
    }

    DatabaseInstanceImporter(Parameters parameters, IDatabaseAdminDAO exportDAO, IDatabaseAdminDAO uploadDAO, IDatabaseDumper databaseDumper) {
        this.exportDAO = exportDAO;
        this.uploadDAO = uploadDAO;
        this.databaseDumper = databaseDumper;
        this.importedDumpFile = new File(parameters.getDumpFileName());
        this.uploadFolder = new File(parameters.getUploadFolder());
        this.codeForImportedDatabaseInstanceOrNull = parameters.getDatabaseInstanceCode();
        this.currentDumpFile = new File(this.uploadFolder, "db_dump.sql");
        this.currentDatabaseFolder = new File(this.uploadFolder, "current-database");
        this.currentDatabaseFolder.mkdirs();
        this.importDatabaseFolder = new File(this.uploadFolder, "import-database");
        this.importDatabaseFolder.mkdirs();
    }

    void importDatabase() {
        String databaseName = this.exportDAO.getDatabaseName();
        this.dumpDatabase(databaseName);
        this.logInfo("Create upload files in directory '" + this.currentDatabaseFolder.getAbsolutePath() + "'.");
        SimpleDatabaseMetaData currentMetaData = this.createUploadFiles(this.currentDumpFile, this.currentDatabaseFolder);
        this.logInfo("Start importing database from dump file '" + this.importedDumpFile.getAbsolutePath() + "'.");
        this.logInfo("Create upload files in directory '" + this.importDatabaseFolder.getAbsolutePath() + "'.");
        SimpleDatabaseMetaData metaData = this.createUploadFiles(this.importedDumpFile, this.importDatabaseFolder);
        this.checkMetaData(currentMetaData, metaData);
        this.checkAndModifyDatabaseInstanceFile(currentMetaData, metaData);
        this.mergeTables(this.exportDAO, currentMetaData, metaData);
        this.replaceCurrentDatabase(databaseName, currentMetaData);
    }

    private void replaceCurrentDatabase(String databaseName, SimpleDatabaseMetaData currentMetaData) {
        String databaseVersion = currentMetaData.getDatabaseVersion();
        this.logInfo("Replace current database '" + databaseName + "' (version " + databaseVersion + ") by the merged one.");
        this.logInfo("Drop current database.");
        this.uploadDAO.dropDatabase();
        this.logInfo("Upload merged database.");
        this.uploadDAO.restoreDatabaseFromDump(this.currentDatabaseFolder, databaseVersion);
        this.logInfo("Merged database successfully uploaded.");
    }

    private void mergeTables(IDatabaseAdminDAO adminDAO, SimpleDatabaseMetaData currentMetaData, SimpleDatabaseMetaData metaData) {
        DatabaseDefinition databaseDefinition = adminDAO.getDatabaseDefinition();
        Set<TableDefinition> tables = databaseDefinition.getTablesDependingOn(DATABASE_INSTANCES);
        tables.add(databaseDefinition.getTableDefinition(DATABASE_INSTANCES));
        for (TableDefinition tableDefinition : tables) {
            String tableName = tableDefinition.getTableName();
            this.logInfo("Merge table '" + tableName + "'.");
            SimpleTableMetaData tableMetaData = metaData.tryToGetTableMetaData(tableName);
            int[] indexMap = this.createIndexMap(tableName, currentMetaData, metaData);
            long[] offsets = new long[indexMap.length];
            for (TableColumnDefinition tableColumnDefinition : tableDefinition) {
                String columnName = tableColumnDefinition.getColumnName();
                if (tableColumnDefinition.isPrimaryKey()) {
                    long offset = tableColumnDefinition.getLargestPrimaryKey();
                    int columnIndex = tableMetaData.getIndexOfColumn(columnName);
                    offsets[columnIndex] = offset;
                    continue;
                }
                TableColumnDefinition reference = tableColumnDefinition.getForeignKeyReference();
                if (reference == null || !tables.contains(reference.getTableDefinition())) continue;
                long offset = reference.getLargestPrimaryKey();
                int columnIndex = tableMetaData.getIndexOfColumn(columnName);
                offsets[columnIndex] = offset;
            }
            File currentTabFile = new File(this.currentDatabaseFolder, currentMetaData.tryToGetTableMetaData(tableName).getTableFileName());
            File importedTabFile = new File(this.importDatabaseFolder, tableMetaData.getTableFileName());
            this.modifyKeys(currentTabFile, importedTabFile, indexMap, offsets);
        }
    }

    private int[] createIndexMap(String tableName, SimpleDatabaseMetaData currentMetaData, SimpleDatabaseMetaData metaData) {
        List<String> currentColumnNames;
        int currentTableColumnsCount;
        SimpleTableMetaData tableMetaData = metaData.tryToGetTableMetaData(tableName);
        SimpleTableMetaData currentTableMetaData = currentMetaData.tryToGetTableMetaData(tableName);
        List<String> columnNames = tableMetaData.getColumnNames();
        int tableColumnsCount = columnNames.size();
        if (tableColumnsCount != (currentTableColumnsCount = (currentColumnNames = currentTableMetaData.getColumnNames()).size())) {
            throw new UserFailureException("Current table has " + currentTableColumnsCount + " columns but imported one " + tableColumnsCount + " columns.");
        }
        int[] indexMap = new int[tableColumnsCount];
        int i = 0;
        while (i < indexMap.length) {
            String currentColumnName = currentColumnNames.get(i);
            indexMap[i] = columnNames.indexOf(currentColumnName);
            ++i;
        }
        return indexMap;
    }

    private void modifyKeys(File currentTabFile, File importedTabFile, int[] indexMap, long[] offsets) {
        List<String> importedTabLines = FileUtilities.loadToStringList(importedTabFile);
        File newUploadFile = new File(this.uploadFolder, "temp.tsv");
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(newUploadFile);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(fileWriter), true);
        try {
            try {
                DatabaseInstanceImporter.copyTo(writer, currentTabFile);
                for (String line : importedTabLines) {
                    String[] tokens = line.split("\t");
                    if (indexMap.length != tokens.length) {
                        throw new IllegalArgumentException(String.valueOf(indexMap.length) + " tokens expected instead of " + tokens.length + ": " + line);
                    }
                    StringBuilder builder = new StringBuilder();
                    int i = 0;
                    while (i < indexMap.length) {
                        String token;
                        block16: {
                            int indexInImportedLine = indexMap[i];
                            long offset = offsets[indexInImportedLine];
                            token = tokens[indexInImportedLine];
                            if (offset > 0L) {
                                try {
                                    token = Long.toString(Long.parseLong(token) + offset);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    if (token.equals("\\N")) break block16;
                                    throw new IllegalArgumentException(String.valueOf(i) + ":" + (indexInImportedLine + 1) + ". token is not a number: " + line);
                                }
                            }
                        }
                        builder.append(token);
                        if (i < offsets.length - 1) {
                            builder.append('\t');
                        }
                        ++i;
                    }
                    writer.println(builder);
                }
                writer.close();
                if (!currentTabFile.delete()) {
                    throw new IOException("Couldn't delete file '" + currentTabFile.getAbsolutePath() + "'.");
                }
                if (!newUploadFile.renameTo(currentTabFile)) {
                    throw new IOException("Couldn't rename file '" + newUploadFile.getAbsolutePath() + "' to '" + currentTabFile.getAbsolutePath() + "'.");
                }
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
        finally {
            IOUtils.closeQuietly((Writer)fileWriter);
        }
    }

    private static final void copyTo(PrintWriter writer, File file) throws IOException {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            IOUtils.copy((Reader)fileReader, (Writer)writer);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)fileReader);
    }

    private void checkAndModifyDatabaseInstanceFile(SimpleDatabaseMetaData currentMetaData, SimpleDatabaseMetaData metaData) {
        List<DatabaseInstance> currentDatabaseInstances = this.listDatabaseInstances(currentMetaData, this.currentDatabaseFolder);
        List<DatabaseInstance> databaseInstances = this.listDatabaseInstances(metaData, this.importDatabaseFolder);
        if (databaseInstances.size() == 0) {
            throw new UserFailureException("Database to be imported has no database instances.");
        }
        if (databaseInstances.size() > 1) {
            throw new UserFailureException("Databases to be imported has " + databaseInstances.size() + " database instances.");
        }
        DatabaseInstance databaseInstance = databaseInstances.get(0);
        for (DatabaseInstance currentDatabaseInstance : currentDatabaseInstances) {
            if (!currentDatabaseInstance.getUUID().equals(databaseInstance.getUUID())) continue;
            throw new UserFailureException("Database instance '" + databaseInstance.getCode() + "' couldn't be imported because it has the same UUID " + "as already existing database instance '" + currentDatabaseInstance.getCode() + "'.");
        }
        String code = databaseInstance.getCode();
        String newCode = this.codeForImportedDatabaseInstanceOrNull;
        if (newCode == null) {
            newCode = code;
        }
        for (DatabaseInstance currentDatabaseInstance : currentDatabaseInstances) {
            if (!currentDatabaseInstance.getCode().equals(newCode)) continue;
            throw new UserFailureException("There is already a database instance with code '" + newCode + "'. Please, choose another code with the command line option '-d'.");
        }
        if (!code.equals(newCode) || databaseInstance.isOriginalSource()) {
            databaseInstance.setCode(newCode);
            databaseInstance.setOriginalSource(false);
            String fileName = metaData.tryToGetTableMetaData(DATABASE_INSTANCES).getTableFileName();
            File file = new File(this.importDatabaseFolder, fileName);
            FileUtilities.writeToFile(file, databaseInstance.toString());
        }
    }

    private List<DatabaseInstance> listDatabaseInstances(SimpleDatabaseMetaData metaData, File tabFileFolder) {
        SimpleTableMetaData tableMetaData = metaData.tryToGetTableMetaData(DATABASE_INSTANCES);
        if (tableMetaData == null) {
            throw new UserFailureException("Can not find table 'database_instances' in " + tabFileFolder.getName());
        }
        int numberOfColumns = tableMetaData.getColumnNames().size();
        int indexOfCode = this.getIndexOf(COLUMN_CODE, tableMetaData, tabFileFolder);
        int indexOfUUID = this.getIndexOf(COLUMN_UUID, tableMetaData, tabFileFolder);
        int indexOfOriginalSource = this.getIndexOf(COLUMN_IS_ORIGINAL_SOURCE, tableMetaData, tabFileFolder);
        File tabFile = new File(tabFileFolder, tableMetaData.getTableFileName());
        List<String> tableRows = FileUtilities.loadToStringList(tabFile);
        ArrayList<DatabaseInstance> list = new ArrayList<DatabaseInstance>();
        for (String row : tableRows) {
            String[] cells = row.split("\t");
            if (cells.length != numberOfColumns) {
                throw new UserFailureException("The following row has " + cells.length + " cells instead of " + numberOfColumns + ": " + row);
            }
            DatabaseInstance databaseInstance = new DatabaseInstance(cells, indexOfCode, indexOfUUID, indexOfOriginalSource);
            list.add(databaseInstance);
        }
        return list;
    }

    private int getIndexOf(String columnName, SimpleTableMetaData tableMetaData, File tabFileFolder) {
        int indexOfCode = tableMetaData.getIndexOfColumn(columnName);
        if (indexOfCode < 0) {
            throw new UserFailureException("Missing column '" + columnName + "'  in table '" + DATABASE_INSTANCES + "' in " + tabFileFolder.getName());
        }
        return indexOfCode;
    }

    private void checkMetaData(SimpleDatabaseMetaData currentMetaData, SimpleDatabaseMetaData metaData) {
        Set<String> importedTables;
        String importedVersion;
        String currentVersion = currentMetaData.getDatabaseVersion();
        if (!currentVersion.equals(importedVersion = metaData.getDatabaseVersion())) {
            throw new UserFailureException("Version of current database is " + currentVersion + " which does not match the version of the database to be imported: " + importedVersion);
        }
        Set<String> currentTables = this.getTableNames(currentMetaData);
        if (!currentTables.equals(importedTables = this.getTableNames(metaData))) {
            HashSet<String> missingTables = new HashSet<String>(currentTables);
            missingTables.removeAll(importedTables);
            if (missingTables.size() > 0) {
                throw new UserFailureException("Current database has tables " + missingTables + "\n which do not exist in the database to be imported.");
            }
            HashSet<String> unknownTables = new HashSet<String>(importedTables);
            unknownTables.removeAll(currentTables);
            if (unknownTables.size() > 0) {
                throw new UserFailureException("Current database does not have tables " + unknownTables + "\n which exist in the database to be imported.");
            }
        }
    }

    private Set<String> getTableNames(SimpleDatabaseMetaData metaData) {
        HashSet<String> list = new HashSet<String>();
        for (SimpleTableMetaData tableMetaData : metaData.getTables()) {
            list.add(tableMetaData.getTableName());
        }
        return list;
    }

    private SimpleDatabaseMetaData createUploadFiles(File dumpFile, File folder) {
        try {
            return DumpPreparator.createUploadFiles(dumpFile, folder, true);
        }
        catch (IOException e) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
        }
    }

    private void dumpDatabase(String databaseName) {
        this.logInfo("Dump current database '" + databaseName + "' into '" + this.currentDumpFile.getAbsolutePath() + "'.");
        if (!this.databaseDumper.createDatabaseDump(databaseName, this.currentDumpFile)) {
            throw new UserFailureException("Couldn't dump database");
        }
    }

    private void logInfo(Object message) {
        if (operationLog.isInfoEnabled()) {
            operationLog.info(message);
        }
    }

    public static void main(String[] args) {
        LogInitializer.init();
        Parameters parameters = new Parameters(args, SystemExit.SYSTEM_EXIT);
        DatabaseInstanceImporter importer = new DatabaseInstanceImporter(parameters);
        try {
            importer.importDatabase();
        }
        catch (UserFailureException e) {
            System.out.println();
            System.out.println("ERROR: " + e.getMessage());
            System.exit(1);
        }
    }
}

