/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.search;

import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleLister;
import ch.systemsx.cisd.openbis.generic.server.business.search.AbstractSearchManager;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IHibernateSearchDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchAssociationCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchField;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchSubCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListOrSearchSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.translator.DtoConverters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.DataAccessException;

public class SampleSearchManager
extends AbstractSearchManager<ISampleLister> {
    private final AbstractSearchManager.IRelationshipHandler CHILDREN_RELATIONSHIP_HANDLER = new AbstractSearchManager.IRelationshipHandler(){

        @Override
        public Collection<Long> findRelatedIdsByCriteria(String userId, DetailedSearchCriteria criteria, List<DetailedSearchSubCriteria> otherSubCriterias) {
            return SampleSearchManager.this.findSampleIds(userId, criteria, otherSubCriterias);
        }

        @Override
        public Map<Long, Set<Long>> listIdsToRelatedIds(Collection<Long> sampleIds) {
            return ((ISampleLister)SampleSearchManager.this.lister).getParentToChildrenIdsMap(sampleIds);
        }

        @Override
        public Map<Long, Set<Long>> listRelatedIdsToIds(Collection<Long> childrenSampleIds) {
            return ((ISampleLister)SampleSearchManager.this.lister).getChildToParentsIdsMap(childrenSampleIds);
        }
    };
    private final AbstractSearchManager.IRelationshipHandler PARENT_RELATIONSHIP_HANDLER = new AbstractSearchManager.IRelationshipHandler(){

        @Override
        public Collection<Long> findRelatedIdsByCriteria(String userId, DetailedSearchCriteria criteria, List<DetailedSearchSubCriteria> otherSubCriterias) {
            return SampleSearchManager.this.findSampleIds(userId, criteria, otherSubCriterias);
        }

        @Override
        public Map<Long, Set<Long>> listIdsToRelatedIds(Collection<Long> sampleIds) {
            return ((ISampleLister)SampleSearchManager.this.lister).getChildToParentsIdsMap(sampleIds);
        }

        @Override
        public Map<Long, Set<Long>> listRelatedIdsToIds(Collection<Long> parentSampleIds) {
            return ((ISampleLister)SampleSearchManager.this.lister).getParentToChildrenIdsMap(parentSampleIds);
        }
    };

    public SampleSearchManager(IHibernateSearchDAO searchDAO, ISampleLister sampleLister) {
        super(searchDAO, sampleLister);
    }

    public List<Sample> searchForSamples(String userId, DetailedSearchCriteria criteria) throws DataAccessException {
        return ((ISampleLister)this.lister).list(new ListOrSearchSampleCriteria(this.searchForSampleIDs(userId, criteria)));
    }

    public Collection<Long> searchForSampleIDs(String userId, DetailedSearchCriteria criteria) {
        DetailedSearchCriteria parentCriteria = new DetailedSearchCriteria();
        DetailedSearchCriteria childCriteria = new DetailedSearchCriteria();
        ArrayList<DetailedSearchSubCriteria> otherSubCriterias = new ArrayList<DetailedSearchSubCriteria>();
        this.groupSampleSubCriteria(criteria.getSubCriterias(), parentCriteria, childCriteria, otherSubCriterias);
        boolean hasMainCriteria = !criteria.getCriteria().isEmpty() || !otherSubCriterias.isEmpty();
        boolean hasParentCriteria = !parentCriteria.isEmpty();
        boolean hasChildCriteria = !childCriteria.isEmpty();
        Collection<Long> sampleIds = null;
        if ((hasMainCriteria || !hasMainCriteria && !hasParentCriteria && !hasChildCriteria) && (sampleIds = this.findSampleIds(userId, criteria, otherSubCriterias)) == null) {
            sampleIds = Collections.emptyList();
        }
        if (hasParentCriteria) {
            sampleIds = this.filterSearchResultsBySubcriteria(userId, sampleIds, parentCriteria, this.PARENT_RELATIONSHIP_HANDLER);
        }
        if (hasChildCriteria) {
            sampleIds = this.filterSearchResultsBySubcriteria(userId, sampleIds, childCriteria, this.CHILDREN_RELATIONSHIP_HANDLER);
        }
        return this.restrictResultSetIfNecessary(sampleIds);
    }

    private void groupSampleSubCriteria(List<DetailedSearchSubCriteria> allSubCriterias, DetailedSearchCriteria parentCriteria, DetailedSearchCriteria childCriteria, List<DetailedSearchSubCriteria> otherSubCriterias) {
        parentCriteria.setCriteria(new ArrayList<DetailedSearchCriterion>());
        childCriteria.setCriteria(new ArrayList<DetailedSearchCriterion>());
        for (DetailedSearchSubCriteria subCriteria : allSubCriterias) {
            switch (subCriteria.getTargetEntityKind()) {
                case SAMPLE_PARENT: {
                    this.mergeSubCriteria(parentCriteria, subCriteria);
                    break;
                }
                case SAMPLE_CHILD: {
                    this.mergeSubCriteria(childCriteria, subCriteria);
                    break;
                }
                default: {
                    otherSubCriterias.add(subCriteria);
                }
            }
        }
    }

    private List<Long> findSampleIds(String userId, DetailedSearchCriteria criteria, List<DetailedSearchSubCriteria> subCriterias) {
        ArrayList<DetailedSearchAssociationCriteria> associations = new ArrayList<DetailedSearchAssociationCriteria>();
        for (DetailedSearchSubCriteria subCriteria : subCriterias) {
            associations.add(this.findAssociatedEntities(userId, subCriteria));
        }
        if (subCriterias.isEmpty() && criteria.getCriteria().isEmpty()) {
            criteria.getCriteria().add(new DetailedSearchCriterion(DetailedSearchField.createAttributeField(SampleAttributeSearchFieldKind.CODE), "*"));
        }
        List<Long> sampleIds = this.searchDAO.searchForEntityIds(userId, criteria, DtoConverters.convertEntityKind(EntityKind.SAMPLE), associations);
        return sampleIds;
    }
}

