/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess;

import ch.systemsx.cisd.common.collection.IExtendedBlockingQueue;
import ch.systemsx.cisd.common.io.PersistentExtendedBlockingQueueFactory;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.DynamicPropertyEvaluationOperation;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDynamicPropertyEvaluationSchedulerWithQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public final class DynamicPropertyEvaluationScheduler
implements IDynamicPropertyEvaluationSchedulerWithQueue {
    public static final String DYNAMIC_PROPERTY_EVALUATOR_QUEUE_FILENAME = ".dynamic_property_evaluator_queue";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DynamicPropertyEvaluationScheduler.class);
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, DynamicPropertyEvaluationScheduler.class);
    private static final ThreadLocal<List<DynamicPropertyEvaluationOperation>> threadQueue = new ThreadLocal<List<DynamicPropertyEvaluationOperation>>(){

        @Override
        protected List<DynamicPropertyEvaluationOperation> initialValue() {
            return new ArrayList<DynamicPropertyEvaluationOperation>();
        }
    };
    private final IExtendedBlockingQueue<DynamicPropertyEvaluationOperation> evaluatorQueue;

    public static List<DynamicPropertyEvaluationOperation> getThreadOperations() {
        return threadQueue.get();
    }

    public DynamicPropertyEvaluationScheduler() {
        File queueFile = DynamicPropertyEvaluationScheduler.getEvaluatorQueueFile();
        operationLog.info((Object)String.format("Evaluator queue file: %s.", queueFile.getAbsolutePath()));
        this.evaluatorQueue = DynamicPropertyEvaluationScheduler.createEvaluatorQueue(queueFile);
    }

    private static IExtendedBlockingQueue<DynamicPropertyEvaluationOperation> createEvaluatorQueue(File queueFile) {
        try {
            return PersistentExtendedBlockingQueueFactory.createSmartPersist(queueFile);
        }
        catch (RuntimeException e) {
            String newFileName = ".dynamic_property_evaluator_queue_" + System.currentTimeMillis();
            notificationLog.error((Object)String.format("%s.\n Renaming '%s' to '%s' and using an empty queue file. Restart server with the queue that caused the problem or wait for maintenance task to reevaluate all properties.", e.getMessage(), queueFile, newFileName));
            queueFile.renameTo(new File(newFileName));
            return PersistentExtendedBlockingQueueFactory.createSmartPersist(queueFile);
        }
    }

    private static File getEvaluatorQueueFile() {
        return new File(DYNAMIC_PROPERTY_EVALUATOR_QUEUE_FILENAME);
    }

    @Override
    public void clear() {
        this.evaluatorQueue.clear();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)"Cleared evaluator queue.");
        }
    }

    @Override
    public void scheduleUpdate(DynamicPropertyEvaluationOperation operation) {
        this.threadDebugLog("Scheduling update: " + operation);
        List<DynamicPropertyEvaluationOperation> threadOperations = DynamicPropertyEvaluationScheduler.getThreadOperations();
        threadOperations.add(operation);
    }

    @Override
    public void synchronizeThreadQueue() {
        List<DynamicPropertyEvaluationOperation> threadOperations = DynamicPropertyEvaluationScheduler.getThreadOperations();
        if (threadOperations.size() > 0) {
            this.threadDebugLog("Synchronizing scheduled operations");
            for (DynamicPropertyEvaluationOperation operation : threadOperations) {
                this.evaluatorQueue.add(operation);
            }
            threadOperations.clear();
        } else {
            this.threadDebugLog("Nothing to synchronize");
        }
    }

    @Override
    public void clearThreadQueue() {
        this.threadDebugLog("Clearing scheduled operations");
        List<DynamicPropertyEvaluationOperation> threadOperations = DynamicPropertyEvaluationScheduler.getThreadOperations();
        threadOperations.clear();
    }

    void threadDebugLog(String msg) {
        if (operationLog.isDebugEnabled()) {
            String threadPrefix = "[" + Thread.currentThread().hashCode() + "]: ";
            operationLog.debug((Object)(String.valueOf(threadPrefix) + msg));
        }
    }

    @Override
    public DynamicPropertyEvaluationOperation peekWait() throws InterruptedException {
        return this.evaluatorQueue.peekWait();
    }

    @Override
    public DynamicPropertyEvaluationOperation take() throws InterruptedException {
        return (DynamicPropertyEvaluationOperation)this.evaluatorQueue.take();
    }
}

