/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPropertyPlaceholderCreator;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicConstant;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import java.util.Set;

class PlaceholderPropertyCreator
implements IPropertyPlaceholderCreator {
    PlaceholderPropertyCreator() {
    }

    @Override
    public void addDynamicPropertiesPlaceholders(Set<IEntityProperty> definedProperties, Set<String> dynamicProperties) {
        this.addPlaceholders(definedProperties, dynamicProperties, BasicConstant.DYNAMIC_PROPERTY_PLACEHOLDER_VALUE);
    }

    @Override
    public void addManagedPropertiesPlaceholders(Set<IEntityProperty> definedProperties, Set<String> managedProperties) {
        this.addPlaceholders(definedProperties, managedProperties, BasicConstant.MANAGED_PROPERTY_PLACEHOLDER_VALUE);
    }

    private void addPlaceholders(Set<IEntityProperty> definedProperties, Set<String> placeholderProperties, String placeholderValue) {
        for (String p : placeholderProperties) {
            if (definedProperties.contains(p)) continue;
            EntityProperty entityProperty = new EntityProperty();
            entityProperty.setValue(placeholderValue);
            PropertyType propertyType = new PropertyType();
            propertyType.setCode(p);
            entityProperty.setPropertyType(propertyType);
            definedProperties.add(entityProperty);
        }
    }
}

