/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.collection.CollectionStyle;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.openbis.generic.server.batch.BatchOperationExecutor;
import ch.systemsx.cisd.openbis.generic.server.batch.IBatchOperation;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDynamicPropertyEvaluationScheduler;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.PersistencyResources;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IFullTextIndexUpdateScheduler;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IndexUpdateOperation;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.hibernate.StatelessSession;
import org.springframework.dao.DataAccessException;

public abstract class AbstractGenericEntityWithPropertiesDAO<T extends IEntityInformationWithPropertiesHolder>
extends AbstractGenericEntityDAO<T> {
    protected static final String ATTACHMENT_CONTENT_IDS_PARAM = "attachmentContentIds";
    protected static final String DESCRIPTION_PARAM = "description";
    protected static final String ENTITY_IDS_PARAM = "entityIds";
    protected static final String ENTITY_TYPE_PARAM = "entityType";
    protected static final String EVENT_TYPE_PARAM = "eventType";
    protected static final String IDENTIFIERS_PARAM = "identifiers";
    protected static final String REGISTRATOR_ID_PARAM = "registratorId";
    protected static final String REASON_PARAM = "reason";
    private final PersistencyResources persistencyResources;

    protected AbstractGenericEntityWithPropertiesDAO(PersistencyResources persistencyResources, DatabaseInstancePE databaseInstance, Class<T> entityClass) {
        super(persistencyResources.getSessionFactory(), databaseInstance, entityClass);
        this.persistencyResources = persistencyResources;
    }

    protected IFullTextIndexUpdateScheduler getIndexUpdateScheduler() {
        return this.persistencyResources.getIndexUpdateScheduler();
    }

    protected IDynamicPropertyEvaluationScheduler getDynamicPropertyEvaluatorScheduler() {
        return this.persistencyResources.getDynamicPropertyEvaluationScheduler();
    }

    protected DataSource getDataSource() {
        return this.persistencyResources.getContext().getDataSource();
    }

    @Override
    public void delete(T entity) throws DataAccessException {
        super.delete(entity);
        this.scheduleRemoveFromFullTextIndex(Collections.singletonList(entity.getId()));
    }

    protected void scheduleRemoveFromFullTextIndex(List<Long> ids) {
        this.getIndexUpdateScheduler().scheduleUpdate(IndexUpdateOperation.remove(this.getEntityClass(), ids));
    }

    protected void scheduleDynamicPropertiesEvaluation(List<T> entities) {
        AbstractGenericEntityWithPropertiesDAO.scheduleDynamicPropertiesEvaluation(this.getDynamicPropertyEvaluatorScheduler(), this.getEntityClass(), entities);
    }

    protected void scheduleDynamicPropertiesEvaluationByIds(List<Long> ids) {
        AbstractGenericEntityWithPropertiesDAO.scheduleDynamicPropertiesEvaluationForIds(this.getDynamicPropertyEvaluatorScheduler(), this.getEntityClass(), ids);
    }

    protected void executePermanentDeleteAction(EventPE.EntityType entityType, List<TechId> entityTechIds, PersonPE registrator, String reason, String sqlSelectPermIds, String sqlDeleteProperties, String sqlSelectAttachmentContentIds, String sqlDeleteAttachmentContents, String sqlDeleteAttachments, String sqlDeleteEntities, String sqlInsertEvent) {
        List<Long> entityIds = TechId.asLongs(entityTechIds);
        DeletePermanentlyBatchOperation deleteOperation = new DeletePermanentlyBatchOperation(entityType, entityIds, registrator, reason, sqlSelectPermIds, sqlDeleteProperties, sqlSelectAttachmentContentIds, sqlDeleteAttachmentContents, sqlDeleteAttachments, sqlDeleteEntities, sqlInsertEvent);
        BatchOperationExecutor.executeInBatches(deleteOperation);
        this.scheduleRemoveFromFullTextIndex(entityIds);
    }

    abstract Logger getLogger();

    protected class DeletePermanentlyBatchOperation
    implements IBatchOperation<Long> {
        private final EventPE.EntityType entityType;
        private final List<Long> allEntityIds;
        private final PersonPE registrator;
        private final String reason;
        private final String sqlSelectPermIds;
        private final String sqlDeleteProperties;
        private final String sqlSelectAttachmentContentIds;
        private final String sqlDeleteAttachmentContents;
        private final String sqlDeleteAttachments;
        private final String sqlDeleteEntities;
        private final String sqlInsertEvent;

        DeletePermanentlyBatchOperation(EventPE.EntityType entityType, List<Long> allEntityIds, PersonPE registrator, String reason, String sqlSelectPermIds, String sqlDeleteProperties, String sqlSelectAttachmentContentIds, String sqlDeleteAttachmentContents, String sqlDeleteAttachments, String sqlDeleteEntities, String sqlInsertEvent) {
            this.entityType = entityType;
            this.allEntityIds = allEntityIds;
            this.registrator = registrator;
            this.reason = reason;
            this.sqlSelectPermIds = sqlSelectPermIds;
            this.sqlDeleteProperties = sqlDeleteProperties;
            this.sqlSelectAttachmentContentIds = sqlSelectAttachmentContentIds;
            this.sqlDeleteAttachmentContents = sqlDeleteAttachmentContents;
            this.sqlDeleteAttachments = sqlDeleteAttachments;
            this.sqlDeleteEntities = sqlDeleteEntities;
            this.sqlInsertEvent = sqlInsertEvent;
        }

        @Override
        public List<Long> getAllEntities() {
            return this.allEntityIds;
        }

        @Override
        public String getEntityName() {
            return this.entityType.name();
        }

        @Override
        public String getOperationName() {
            return "permanently deleting";
        }

        @Override
        public void execute(List<Long> batchEntityIds) {
            AbstractGenericEntityWithPropertiesDAO.this.executeStatelessAction(this.createPermanentDeleteAction(batchEntityIds));
        }

        private AbstractDAO.StatelessHibernateCallback createPermanentDeleteAction(List<Long> entityIdsToDelete) {
            return new PermanentDeletionAction(entityIdsToDelete);
        }

        private class PermanentDeletionAction
        implements AbstractDAO.StatelessHibernateCallback {
            private final List<Long> entityIdsToDelete;

            public PermanentDeletionAction(List<Long> entityIdsToDelete) {
                this.entityIdsToDelete = entityIdsToDelete;
            }

            @Override
            public Object doInStatelessSession(StatelessSession session) {
                SQLQuery sqlQuerySelectPermIds = session.createSQLQuery(DeletePermanentlyBatchOperation.this.sqlSelectPermIds);
                SQLQuery sqlQueryDeleteProperties = session.createSQLQuery(DeletePermanentlyBatchOperation.this.sqlDeleteProperties);
                SQLQuery sqlQueryDeleteEntities = session.createSQLQuery(DeletePermanentlyBatchOperation.this.sqlDeleteEntities);
                SQLQuery sqlQueryInsertEvent = session.createSQLQuery(DeletePermanentlyBatchOperation.this.sqlInsertEvent);
                SQLQuery sqlQuerySelectAttachmentContentIds = session.createSQLQuery(DeletePermanentlyBatchOperation.this.sqlSelectAttachmentContentIds);
                SQLQuery sqlQueryDeleteAttachments = session.createSQLQuery(DeletePermanentlyBatchOperation.this.sqlDeleteAttachments);
                SQLQuery sqlQueryDeleteAttachmentContents = session.createSQLQuery(DeletePermanentlyBatchOperation.this.sqlDeleteAttachmentContents);
                List<String> permIds = this.selectPermIds(sqlQuerySelectPermIds, this.entityIdsToDelete);
                if (permIds.isEmpty()) {
                    return null;
                }
                this.deleteProperties(sqlQueryDeleteProperties, this.entityIdsToDelete);
                this.deleteAttachmentsWithContents(sqlQuerySelectAttachmentContentIds, sqlQueryDeleteAttachments, sqlQueryDeleteAttachmentContents, this.entityIdsToDelete);
                this.deleteMainEntities(sqlQueryDeleteEntities, this.entityIdsToDelete);
                this.insertEvent(sqlQueryInsertEvent, permIds);
                return null;
            }

            private List<String> selectPermIds(SQLQuery sqlQuerySelectPermIds, List<Long> entityIds) {
                sqlQuerySelectPermIds.setParameterList(AbstractGenericEntityWithPropertiesDAO.ENTITY_IDS_PARAM, entityIds);
                List permIdsOrNull = AbstractGenericEntityWithPropertiesDAO.cast(sqlQuerySelectPermIds.list());
                return permIdsOrNull == null ? Collections.emptyList() : permIdsOrNull;
            }

            private void deleteProperties(SQLQuery sqlQueryDeleteProperties, List<Long> entityIds) {
                sqlQueryDeleteProperties.setParameterList(AbstractGenericEntityWithPropertiesDAO.ENTITY_IDS_PARAM, entityIds);
                sqlQueryDeleteProperties.executeUpdate();
            }

            private void deleteAttachmentsWithContents(SQLQuery sqlQuerySelectAttachmentContentIds, SQLQuery sqlQueryDeleteAttachments, SQLQuery sqlQueryDeleteAttachmentContents, List<Long> entityIds) {
                sqlQuerySelectAttachmentContentIds.setParameterList(AbstractGenericEntityWithPropertiesDAO.ENTITY_IDS_PARAM, entityIds);
                List attachmentContentIds = AbstractGenericEntityWithPropertiesDAO.cast(sqlQuerySelectAttachmentContentIds.list());
                if (attachmentContentIds.size() > 0) {
                    sqlQueryDeleteAttachments.setParameterList(AbstractGenericEntityWithPropertiesDAO.ENTITY_IDS_PARAM, entityIds);
                    sqlQueryDeleteAttachments.executeUpdate();
                    sqlQueryDeleteAttachmentContents.setParameterList(AbstractGenericEntityWithPropertiesDAO.ATTACHMENT_CONTENT_IDS_PARAM, attachmentContentIds);
                    sqlQueryDeleteAttachmentContents.executeUpdate();
                }
            }

            private void deleteMainEntities(SQLQuery sqlQueryDeleteEntities, List<Long> entityIds) {
                sqlQueryDeleteEntities.setParameterList(AbstractGenericEntityWithPropertiesDAO.ENTITY_IDS_PARAM, entityIds);
                sqlQueryDeleteEntities.executeUpdate();
            }

            private void insertEvent(SQLQuery sqlQueryInsertEvent, List<String> permIds) {
                String description = CollectionUtils.abbreviate(permIds, 3, CollectionStyle.NO_BOUNDARY);
                sqlQueryInsertEvent.setParameter(AbstractGenericEntityWithPropertiesDAO.DESCRIPTION_PARAM, (Object)description);
                sqlQueryInsertEvent.setParameter(AbstractGenericEntityWithPropertiesDAO.EVENT_TYPE_PARAM, (Object)EventType.DELETION.name());
                sqlQueryInsertEvent.setParameter(AbstractGenericEntityWithPropertiesDAO.REASON_PARAM, (Object)DeletePermanentlyBatchOperation.this.reason);
                sqlQueryInsertEvent.setParameter(AbstractGenericEntityWithPropertiesDAO.REGISTRATOR_ID_PARAM, (Object)DeletePermanentlyBatchOperation.this.registrator.getId());
                sqlQueryInsertEvent.setParameter(AbstractGenericEntityWithPropertiesDAO.ENTITY_TYPE_PARAM, (Object)DeletePermanentlyBatchOperation.this.entityType.name());
                String allPermIdsAsString = CollectionUtils.abbreviate(permIds, -1, CollectionStyle.NO_BOUNDARY);
                sqlQueryInsertEvent.setParameter(AbstractGenericEntityWithPropertiesDAO.IDENTIFIERS_PARAM, (Object)allPermIdsAsString);
                sqlQueryInsertEvent.executeUpdate();
            }
        }
    }

    protected static class SQLBuilder {
        protected SQLBuilder() {
        }

        protected static String createSelectPermIdsSQL(String entitiesTable) {
            return "SELECT perm_id FROM " + entitiesTable + " WHERE id " + SQLBuilder.inEntityIds();
        }

        protected static String createDeletePropertiesSQL(String propertiesTable, String ownerColumnName) {
            return "DELETE FROM " + propertiesTable + " WHERE " + ownerColumnName + " " + SQLBuilder.inEntityIds();
        }

        protected static String createSelectAttachmentContentIdsSQL(String ownerColumnName) {
            return "SELECT exac_id FROM attachments WHERE " + ownerColumnName + " " + SQLBuilder.inEntityIds();
        }

        protected static String createDeleteAttachmentContentsSQL() {
            return "DELETE FROM attachment_contents WHERE id " + SQLBuilder.in(AbstractGenericEntityWithPropertiesDAO.ATTACHMENT_CONTENT_IDS_PARAM);
        }

        protected static String createDeleteAttachmentsSQL(String ownerColumnName) {
            return "DELETE FROM attachments WHERE " + ownerColumnName + " " + SQLBuilder.inEntityIds();
        }

        protected static String createDeleteEnitiesSQL(String entitiesTable) {
            return "DELETE FROM " + entitiesTable + " WHERE id " + SQLBuilder.inEntityIds();
        }

        protected static String createInsertEventSQL() {
            return String.format("INSERT INTO %s (id, event_type, description, reason, pers_id_registerer, entity_type, identifiers) VALUES (nextval('%s'), :%s, :%s, :%s, :%s, :%s, :%s)", "events", "EVENT_ID_SEQ", AbstractGenericEntityWithPropertiesDAO.EVENT_TYPE_PARAM, AbstractGenericEntityWithPropertiesDAO.DESCRIPTION_PARAM, AbstractGenericEntityWithPropertiesDAO.REASON_PARAM, AbstractGenericEntityWithPropertiesDAO.REGISTRATOR_ID_PARAM, AbstractGenericEntityWithPropertiesDAO.ENTITY_TYPE_PARAM, AbstractGenericEntityWithPropertiesDAO.IDENTIFIERS_PARAM);
        }

        protected static String inEntityIds() {
            return SQLBuilder.in(AbstractGenericEntityWithPropertiesDAO.ENTITY_IDS_PARAM);
        }

        protected static String in(String paramName) {
            return "IN (:" + paramName + ")";
        }
    }
}

