/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;

abstract class AbstractTypeDAO<T extends AbstractTypePE>
extends AbstractGenericEntityDAO<T> {
    private final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, this.getClass());

    public AbstractTypeDAO(SessionFactory sessionFactory, DatabaseInstancePE databaseInstance, Class<T> entityClass) {
        super(sessionFactory, databaseInstance, entityClass);
    }

    final T tryFindTypeByCode(String code) throws DataAccessException {
        return this.tryFindTypeByCode(code, true);
    }

    final T tryFindTypeByCode(String code, boolean appendDatabaseInstance) throws DataAccessException {
        assert (code != null) : "Unspecified code";
        DetachedCriteria criteria = DetachedCriteria.forClass(this.getEntityClass());
        criteria.add((Criterion)Restrictions.eq((String)"code", (Object)CodeConverter.tryToDatabase(code)));
        if (appendDatabaseInstance) {
            criteria.add((Criterion)Restrictions.eq((String)"databaseInstance", (Object)this.getDatabaseInstance()));
        }
        List list = AbstractTypeDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        AbstractTypePE entity = (AbstractTypePE)AbstractTypeDAO.tryFindEntity(list, "type", new Object[0]);
        if (this.operationLog.isDebugEnabled()) {
            this.operationLog.debug((Object)String.format("%s(%s,%s): Entity type '%s' has been found.", MethodUtils.getCurrentMethod().getName(), code, appendDatabaseInstance, entity));
        }
        return (T)entity;
    }

    final List<T> listTypes() throws DataAccessException {
        return this.listTypes(true);
    }

    final List<T> listTypes(boolean appendDatabaseInstance) throws DataAccessException {
        DetachedCriteria criteria = DetachedCriteria.forClass(this.getEntityClass());
        if (appendDatabaseInstance) {
            criteria.add((Criterion)Restrictions.eq((String)"databaseInstance", (Object)this.getDatabaseInstance()));
        }
        List list = AbstractTypeDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (this.operationLog.isDebugEnabled()) {
            this.operationLog.debug((Object)String.format("%s(%s): %d entity type(s) have been found.", MethodUtils.getCurrentMethod().getName(), appendDatabaseInstance, list.size()));
        }
        return list;
    }

    protected void createOrUpdateType(T type) {
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        AbstractTypeDAO.validatePE(type);
        ((AbstractTypePE)type).setCode(CodeConverter.tryToDatabase(((AbstractTypePE)type).getCode()));
        hibernateTemplate.saveOrUpdate(type);
        hibernateTemplate.flush();
        if (this.operationLog.isInfoEnabled()) {
            this.operationLog.info((Object)String.format("ADD/UPDATE: type '%s'.", type));
        }
    }
}

