/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDatabaseInstanceDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.util.UuidUtil;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;

final class DatabaseInstanceDAO
extends AbstractGenericEntityDAO<DatabaseInstancePE>
implements IDatabaseInstanceDAO {
    private static final Class<DatabaseInstancePE> ENTITY_CLASS = DatabaseInstancePE.class;
    private static final String TABLE_NAME = ENTITY_CLASS.getSimpleName();
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DatabaseInstanceDAO.class);

    DatabaseInstanceDAO(SessionFactory sessionFactory) {
        super(sessionFactory, null, ENTITY_CLASS);
    }

    private final DatabaseInstancePE tryFindDatabaseInstanceByCode(String databaseInstanceCode, boolean isUUID) throws DataAccessException {
        List<DatabaseInstancePE> databaseInstances = this.listDatabaseInstances(databaseInstanceCode, isUUID);
        DatabaseInstancePE databaseInstance = DatabaseInstanceDAO.tryFindEntity(databaseInstances, "database instance", new Object[0]);
        if (operationLog.isDebugEnabled()) {
            String foundInstanceDesc = databaseInstance == null ? "not found." : databaseInstance.toString();
            String methodSuffix = isUUID ? "UUID" : "Code";
            operationLog.debug((Object)("tryToFindDatabaseInstanceBy" + methodSuffix + "(" + databaseInstanceCode + "): " + foundInstanceDesc));
        }
        return databaseInstance;
    }

    private final List<DatabaseInstancePE> listDatabaseInstances(String databaseInstanceCode, boolean isUUID) {
        assert (databaseInstanceCode != null) : "Unspecified DatabaseInstance code";
        String code = CodeConverter.tryToDatabase(databaseInstanceCode);
        String columnName = isUUID ? "uuid" : "code";
        List<DatabaseInstancePE> databaseInstances = DatabaseInstanceDAO.cast(this.getHibernateTemplate().find(String.format("from %s d where d." + columnName + " = ? ", TABLE_NAME), DatabaseInstanceDAO.toArray(code)));
        return databaseInstances;
    }

    @Override
    public final DatabaseInstancePE getHomeInstance() throws DataAccessException {
        List list = DatabaseInstanceDAO.cast(this.getHibernateTemplate().find(String.format("from %s d where d.originalSource = ?", TABLE_NAME), DatabaseInstanceDAO.toArray(true)));
        return (DatabaseInstancePE)DatabaseInstanceDAO.getEntity(list);
    }

    @Override
    public final DatabaseInstancePE tryFindDatabaseInstanceByUUID(String databaseInstanceUUID) throws DataAccessException {
        return this.tryFindDatabaseInstanceByCode(databaseInstanceUUID, true);
    }

    @Override
    public final DatabaseInstancePE tryFindDatabaseInstanceByCode(String databaseInstanceCode) throws DataAccessException {
        return this.tryFindDatabaseInstanceByCode(databaseInstanceCode, false);
    }

    @Override
    public final void updateDatabaseInstancePE(DatabaseInstancePE databaseInstancePE) throws DataAccessException {
        assert (databaseInstancePE != null) : "Unspecified database instance";
        DatabaseInstanceDAO.validatePE(databaseInstancePE);
        databaseInstancePE.setCode(CodeConverter.tryToDatabase(databaseInstancePE.getCode()));
        databaseInstancePE.setUuid(CodeConverter.tryToDatabase(databaseInstancePE.getUuid()));
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        hibernateTemplate.update((Object)databaseInstancePE);
        hibernateTemplate.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("UPDATE: database instance '%s'.", databaseInstancePE));
        }
    }

    @Override
    public final List<DatabaseInstancePE> listDatabaseInstances() {
        List<DatabaseInstancePE> list = DatabaseInstanceDAO.cast(this.getHibernateTemplate().loadAll(ENTITY_CLASS));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%d database instance(s) have been found.", list.size()));
        }
        return list;
    }

    @Override
    public final DatabaseInstancePE getDatabaseInstanceById(long databaseInstanceId) throws DataAccessException {
        DatabaseInstancePE databaseInstance = (DatabaseInstancePE)this.getHibernateTemplate().load(ENTITY_CLASS, (Serializable)Long.valueOf(databaseInstanceId));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%d): '%s'.", MethodUtils.getCurrentMethod().getName(), databaseInstanceId, databaseInstance));
        }
        return databaseInstance;
    }

    @Override
    public final void createDatabaseInstance(DatabaseInstancePE databaseInstance) throws DataAccessException {
        assert (databaseInstance != null) : "Unspecified database instance";
        databaseInstance.setUuid(UuidUtil.generateUUID());
        DatabaseInstanceDAO.validatePE(databaseInstance);
        databaseInstance.setCode(CodeConverter.tryToDatabase(databaseInstance.getCode()));
        HibernateTemplate template = this.getHibernateTemplate();
        template.save((Object)databaseInstance);
        template.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("ADD: Database instance '%s'.", databaseInstance));
        }
    }
}

