/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.openbis.common.conversation.context.ServiceConversationsThreadContext;
import ch.systemsx.cisd.openbis.common.conversation.progress.IServiceConversationProgressListener;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.IHibernateTransactionManagerCallback;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.DynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyCalculatorFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.EntityAdaptorFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.INonAbstractEntityAdapter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.JythonEntityValidationCalculator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.entity_validation.IEntityValidatorFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.entity_validation.api.IEntityValidator;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins.api.IEntityAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.EmptyInterceptor;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Restrictions;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.impl.SessionImpl;
import org.hibernate.type.Type;

public class EntityValidationInterceptor
extends EmptyInterceptor
implements JythonEntityValidationCalculator.IValidationRequestDelegate<INonAbstractEntityAdapter> {
    private static final long serialVersionUID = 35L;
    private static int BATCH_SIZE = 1000;
    private IDAOFactory daoFactory;
    private final IEntityValidatorFactory entityValidationFactory;
    private final IDynamicPropertyCalculatorFactory dynamicPropertyCalculatorFactory;
    private final IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;
    IHibernateTransactionManagerCallback callback;
    Set<EntityIdentifier> newEntities;
    Set<EntityIdentifier> entitiesToValidate;
    Set<EntityIdentifier> validatedEntities;
    IServiceConversationProgressListener progressListener;
    int totalEntitiesToValidateCount;
    int entitiesValidatedCount;
    private boolean isRolledBack;

    public EntityValidationInterceptor(IHibernateTransactionManagerCallback callback, IDAOFactory daoFactory, IEntityValidatorFactory entityValidationFactory, IDynamicPropertyCalculatorFactory dynamicPropertyCalculatorFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this.callback = callback;
        this.daoFactory = daoFactory;
        this.entityValidationFactory = entityValidationFactory;
        this.dynamicPropertyCalculatorFactory = dynamicPropertyCalculatorFactory;
        this.managedPropertyEvaluatorFactory = managedPropertyEvaluatorFactory;
        this.initializeLists();
        this.totalEntitiesToValidateCount = 0;
        this.entitiesValidatedCount = 0;
        this.isRolledBack = false;
    }

    private void updateListener() {
        this.progressListener = ServiceConversationsThreadContext.getProgressListener();
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        this.updateListener();
        if (entity instanceof IEntityInformationWithPropertiesHolder) {
            this.newEntity((IEntityInformationWithPropertiesHolder)entity);
        }
        return false;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        this.updateListener();
        if (entity instanceof IEntityInformationWithPropertiesHolder) {
            this.modifiedEntity((IEntityInformationWithPropertiesHolder)entity);
        }
        return false;
    }

    private boolean isCached(Session session, EntityIdentifier identifier) {
        return ((SessionImpl)session).getEntityUsingInterceptor(new EntityKey((Serializable)identifier.getId(), ((SessionFactoryImplementor)this.daoFactory.getSessionFactory()).getEntityPersister(identifier.getEntityClass().getName()), EntityMode.POJO)) != null;
    }

    private Collection<EntityIdentifier> cachedEntities(Session session) {
        HashSet<EntityIdentifier> cached = new HashSet<EntityIdentifier>();
        for (EntityIdentifier identifier : this.entitiesToValidate) {
            if (!this.isCached(session, identifier)) continue;
            cached.add(identifier);
        }
        return cached;
    }

    public void beforeTransactionCompletion(Transaction tx) {
        Session session = this.daoFactory.getSessionFactory().getCurrentSession();
        for (EntityIdentifier entityIdentifier : this.cachedEntities(session)) {
            this.validateEntity(tx, (IEntityInformationWithPropertiesHolder)session.get(entityIdentifier.getEntityClass(), (Serializable)entityIdentifier.getId()));
            if (!this.isRolledBack) continue;
            return;
        }
        while (this.entitiesToValidate.size() > 0) {
            for (List list : this.identifierBatchOf(BATCH_SIZE)) {
                Class<? extends IEntityInformationWithPropertiesHolder> clazz = ((EntityIdentifier)list.get(0)).getEntityClass();
                HashSet<Long> param = new HashSet<Long>();
                for (EntityIdentifier identifier : list) {
                    param.add(identifier.getId());
                }
                Criteria criteria = session.createCriteria(clazz);
                criteria.add(Restrictions.in((String)"id", param));
                criteria.setFetchMode("sampleProperties", FetchMode.JOIN);
                criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
                for (IEntityInformationWithPropertiesHolder entity : criteria.list()) {
                    this.validateEntity(tx, entity);
                    if (!this.isRolledBack) continue;
                    return;
                }
            }
        }
    }

    private Iterable<List<EntityIdentifier>> identifierBatchOf(final int batchSize) {
        final ArrayList<EntityIdentifier> ids = new ArrayList<EntityIdentifier>(this.entitiesToValidate);
        Collections.sort(ids, new Comparator<EntityIdentifier>(){

            @Override
            public int compare(EntityIdentifier arg0, EntityIdentifier arg1) {
                return arg0.getKind().toString().compareTo(arg1.getKind().toString());
            }
        });
        return new Iterable<List<EntityIdentifier>>(){

            @Override
            public Iterator<List<EntityIdentifier>> iterator() {
                return new Iterator<List<EntityIdentifier>>(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < ids.size();
                    }

                    @Override
                    public List<EntityIdentifier> next() {
                        if (this.index >= ids.size()) {
                            return null;
                        }
                        ArrayList<EntityIdentifier> list = new ArrayList<EntityIdentifier>();
                        EntityKind kind = ((EntityIdentifier)ids.get(this.index)).getKind();
                        while (list.size() < batchSize && this.index < ids.size() && ((EntityIdentifier)ids.get(this.index)).getKind().equals((Object)kind)) {
                            list.add((EntityIdentifier)ids.get(this.index));
                            ++this.index;
                        }
                        return list;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private void validateEntity(Transaction tx, IEntityInformationWithPropertiesHolder entity) {
        boolean isNewEntity = this.newEntities.contains(new EntityIdentifier(entity));
        IEntityValidator entityValidator = this.entityValidationFactory.createEntityValidator(entity.getEntityType(), this);
        if (entityValidator != null) {
            try {
                this.validatedEntity(entity);
                this.validateEntityWithScript(tx, entityValidator, entity, isNewEntity);
            }
            catch (Throwable e) {
                this.setRollback(tx, entity, " resulted in error. " + e.getMessage());
            }
        } else {
            this.entitiesToValidate.remove(new EntityIdentifier(entity));
        }
    }

    private void validateEntityWithScript(Transaction tx, IEntityValidator entityValidator, IEntityInformationWithPropertiesHolder entity, boolean isNewEntity) {
        String result = null;
        if (this.progressListener != null) {
            this.progressListener.update("Validation of entities", this.totalEntitiesToValidateCount, this.entitiesValidatedCount);
        }
        if ((result = this.calculate(entityValidator, entity, isNewEntity)) != null) {
            this.setRollback(tx, entity, " failed. " + result);
        }
    }

    private void setRollback(Transaction tx, IEntityInformationWithPropertiesHolder entity, String msg) {
        this.callback.rollbackTransaction(tx, "Validation of " + this.entityDescription(entity) + msg);
        this.isRolledBack = true;
    }

    private String entityDescription(IEntityInformationWithPropertiesHolder entity) {
        return String.valueOf(entity.getEntityKind().getLabel()) + " " + entity.getIdentifier() + " (" + entity.getEntityType().getCode() + ")";
    }

    private String calculate(IEntityValidator entityValidator, IEntityInformationWithPropertiesHolder entity, boolean isNewEntity) {
        DynamicPropertyEvaluator evaluator = new DynamicPropertyEvaluator(this.daoFactory, null, this.dynamicPropertyCalculatorFactory, this.managedPropertyEvaluatorFactory);
        IEntityAdaptor adaptor = EntityAdaptorFactory.create(entity, (IDynamicPropertyEvaluator)evaluator, (org.hibernate.Session)this.daoFactory.getSessionFactory().getCurrentSession());
        return entityValidator.validate(adaptor, isNewEntity);
    }

    private boolean addToBeValidated(IEntityInformationWithPropertiesHolder entity) {
        return this.entitiesToValidate.add(new EntityIdentifier(entity));
    }

    private void newEntity(IEntityInformationWithPropertiesHolder entity) {
        if (this.addToBeValidated(entity)) {
            this.newEntities.add(new EntityIdentifier(entity));
            ++this.totalEntitiesToValidateCount;
        }
    }

    private void validatedEntity(IEntityInformationWithPropertiesHolder entity) {
        ++this.entitiesValidatedCount;
        if (!this.validatedEntities.add(new EntityIdentifier(entity))) {
            throw new IllegalStateException("Programming error - trying to validate the same entity twice (" + entity + ")");
        }
        if (!this.entitiesToValidate.remove(new EntityIdentifier(entity))) {
            throw new IllegalStateException("Programming error - could not remove entity from to be validated list (" + entity + ")");
        }
    }

    private void modifiedEntity(IEntityInformationWithPropertiesHolder entity) {
        if (this.addToBeValidated(entity)) {
            ++this.totalEntitiesToValidateCount;
        }
    }

    private void initializeLists() {
        this.validatedEntities = new HashSet<EntityIdentifier>();
        this.newEntities = new HashSet<EntityIdentifier>();
        this.entitiesToValidate = new HashSet<EntityIdentifier>();
    }

    @Override
    public void requestValidation(INonAbstractEntityAdapter entityAdapter) {
        IEntityInformationWithPropertiesHolder entity = entityAdapter.entityPE();
        if (!this.validatedEntities.contains(new EntityIdentifier(entity)) && this.addToBeValidated(entity)) {
            ++this.totalEntitiesToValidateCount;
        }
    }

    private static class EntityIdentifier {
        private final Class<? extends IEntityInformationWithPropertiesHolder> clazz;
        private final String code;
        private final EntityKind kind;
        private final Long id;

        public EntityIdentifier(IEntityInformationWithPropertiesHolder entity) {
            this.clazz = entity.getClass();
            this.code = entity.getCode();
            this.kind = entity.getEntityKind();
            this.id = entity.getId();
        }

        public Class<? extends IEntityInformationWithPropertiesHolder> getEntityClass() {
            return this.clazz;
        }

        public Long getId() {
            return this.id;
        }

        public EntityKind getKind() {
            return this.kind;
        }

        public int hashCode() {
            return this.code.hashCode() + this.kind.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof EntityIdentifier) {
                EntityIdentifier e = (EntityIdentifier)o;
                return e.code.equals(this.code) && e.kind.equals((Object)this.kind);
            }
            throw new IllegalArgumentException(o.toString());
        }

        public String toString() {
            return String.valueOf(this.clazz.getSimpleName()) + ": " + this.code;
        }
    }
}

