/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IGridCustomColumnDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.GridCustomColumnPE;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

public class GridCustomColumnDAO
extends AbstractGenericEntityDAO<GridCustomColumnPE>
implements IGridCustomColumnDAO {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, GridCustomColumnDAO.class);

    public GridCustomColumnDAO(SessionFactory sessionFactory, DatabaseInstancePE databaseInstance) {
        super(sessionFactory, databaseInstance, GridCustomColumnPE.class);
    }

    @Override
    public void createColumn(GridCustomColumnPE column) {
        assert (column != null) : "Unspecified column";
        assert (column.getDatabaseInstance() == null);
        column.setDatabaseInstance(this.getDatabaseInstance());
        this.persist(column);
    }

    @Override
    public List<GridCustomColumnPE> listColumns(String gridId) {
        assert (gridId != null) : "Unspecified grid ID.";
        DetachedCriteria criteria = DetachedCriteria.forClass(this.getEntityClass());
        criteria.add((Criterion)Restrictions.eq((String)"databaseInstance", (Object)this.getDatabaseInstance()));
        criteria.add((Criterion)Restrictions.eq((String)"gridId", (Object)gridId));
        List<GridCustomColumnPE> list = GridCustomColumnDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s): %d column(s) have been found.", MethodUtils.getCurrentMethod().getName(), gridId, list.size()));
        }
        return list;
    }
}

