/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IQueryDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.QueryType;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.QueryPE;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.UncategorizedSQLException;

public class QueryDAO
extends AbstractGenericEntityDAO<QueryPE>
implements IQueryDAO {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, QueryDAO.class);

    public QueryDAO(SessionFactory sessionFactory, DatabaseInstancePE databaseInstance) {
        super(sessionFactory, databaseInstance, QueryPE.class);
    }

    @Override
    public List<QueryPE> listQueries(QueryType queryType) {
        DetachedCriteria criteria = DetachedCriteria.forClass(this.getEntityClass());
        criteria.add((Criterion)Restrictions.eq((String)"databaseInstance", (Object)this.getDatabaseInstance()));
        if (queryType != QueryType.UNSPECIFIED) {
            criteria.add((Criterion)Restrictions.eq((String)"queryType", (Object)queryType));
        }
        List<QueryPE> list = QueryDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(): %d queries have been found.", MethodUtils.getCurrentMethod().getName(), list.size()));
        }
        return list;
    }

    @Override
    public void createQuery(QueryPE query) throws DataAccessException {
        assert (query != null) : "Unspecified query";
        assert (query.getDatabaseInstance() == null);
        query.setDatabaseInstance(this.getDatabaseInstance());
        try {
            this.persist(query);
        }
        catch (UncategorizedSQLException e) {
            QueryDAO.translateUncategorizedSQLException(e);
        }
    }
}

