/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import java.io.Serializable;
import java.util.List;

public class IndexUpdateOperation
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final String className;
    private final List<Long> ids;
    private final IndexUpdateOperationKind operationKind;

    public static IndexUpdateOperation remove(Class<?> clazz, List<Long> ids) {
        return new IndexUpdateOperation(IndexUpdateOperationKind.REMOVE, clazz, ids);
    }

    public static IndexUpdateOperation reindex(Class<?> clazz, List<Long> ids) {
        return new IndexUpdateOperation(IndexUpdateOperationKind.REINDEX, clazz, ids);
    }

    private IndexUpdateOperation(IndexUpdateOperationKind operationKind, Class<?> clazz, List<Long> ids) {
        this.className = clazz.getName();
        this.ids = ids;
        this.operationKind = operationKind;
    }

    public String getClassName() {
        return this.className;
    }

    public List<Long> getIds() {
        return this.ids;
    }

    public IndexUpdateOperationKind getOperationKind() {
        return this.operationKind;
    }

    public String toString() {
        return (Object)((Object)this.operationKind) + " " + this.className + ": " + CollectionUtils.abbreviate(this.ids, 10);
    }

    public static enum IndexUpdateOperationKind {
        REINDEX,
        REMOVE;

    }
}

