/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.detailed;

import ch.systemsx.cisd.common.exceptions.InternalErr;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AssociatedEntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleAttributeSearchFieldKind;

class IndexFieldNameHelper {
    IndexFieldNameHelper() {
    }

    static String getAssociationIndexField(EntityKind entityKind, AssociatedEntityKind associationKind) {
        switch (associationKind) {
            case EXPERIMENT: {
                if (entityKind == EntityKind.SAMPLE || entityKind == EntityKind.DATA_SET) {
                    return "experiment id";
                }
                throw IndexFieldNameHelper.createAssociationNotHandledException(entityKind, associationKind);
            }
            case SAMPLE: {
                if (entityKind == EntityKind.DATA_SET) {
                    return "sample id";
                }
                throw IndexFieldNameHelper.createAssociationNotHandledException(entityKind, associationKind);
            }
            case DATA_SET: {
                throw IndexFieldNameHelper.createAssociationNotHandledException(entityKind, associationKind);
            }
            case SAMPLE_CONTAINER: {
                if (entityKind == EntityKind.SAMPLE) {
                    return "container id";
                }
                throw IndexFieldNameHelper.createAssociationNotHandledException(entityKind, associationKind);
            }
            case DATA_SET_CONTAINER: {
                if (entityKind == EntityKind.DATA_SET) {
                    return "container id";
                }
                throw IndexFieldNameHelper.createAssociationNotHandledException(entityKind, associationKind);
            }
            case DATA_SET_PARENT: 
            case DATA_SET_CHILD: 
            case SAMPLE_CHILD: 
            case SAMPLE_PARENT: 
            case MATERIAL: {
                throw IndexFieldNameHelper.createAssociationNotHandledException(entityKind, associationKind);
            }
        }
        return null;
    }

    private static RuntimeException createAssociationNotHandledException(EntityKind entityKind, AssociatedEntityKind associationKind) {
        return InternalErr.error("Associations between " + entityKind + " and " + associationKind + " are not supported");
    }

    static String getPropertyIndexField(String propertyCode) {
        assert (propertyCode != null) : "property code is null";
        return "property " + propertyCode;
    }

    static String getAttributeIndexField(EntityKind entityKind, String attributeCode) {
        switch (entityKind) {
            case DATA_SET: {
                return IndexFieldNameHelper.getDataSetAttributeIndexField(DataSetAttributeSearchFieldKind.valueOf(attributeCode));
            }
            case EXPERIMENT: {
                return IndexFieldNameHelper.getExperimentAttributeIndexField(ExperimentAttributeSearchFieldKind.valueOf(attributeCode));
            }
            case MATERIAL: {
                return IndexFieldNameHelper.getMaterialAttributeIndexField(MaterialAttributeSearchFieldKind.valueOf(attributeCode));
            }
            case SAMPLE: {
                return IndexFieldNameHelper.getSampleAttributeIndexField(SampleAttributeSearchFieldKind.valueOf(attributeCode));
            }
        }
        return null;
    }

    private static String getDataSetAttributeIndexField(DataSetAttributeSearchFieldKind attributeKind) {
        switch (attributeKind) {
            case CODE: {
                return "code";
            }
            case DATA_SET_TYPE: {
                return "type code";
            }
            case FILE_TYPE: {
                return "file format type code";
            }
            case STORAGE_CONFIRMATION: {
                return "storage_confirmed";
            }
            case METAPROJECT: {
                return "metaproject identifier";
            }
            case REGISTRATION_DATE: 
            case REGISTRATION_DATE_FROM: 
            case REGISTRATION_DATE_UNTIL: {
                return "registration_date";
            }
            case MODIFICATION_DATE: 
            case MODIFICATION_DATE_FROM: 
            case MODIFICATION_DATE_UNTIL: {
                return "modification_date";
            }
        }
        throw new IllegalArgumentException(attributeKind.toString());
    }

    private static String getExperimentAttributeIndexField(ExperimentAttributeSearchFieldKind attributeKind) {
        switch (attributeKind) {
            case CODE: {
                return "code";
            }
            case EXPERIMENT_TYPE: {
                return "type code";
            }
            case PERM_ID: {
                return "perm_id";
            }
            case PROJECT: {
                return "project code";
            }
            case PROJECT_SPACE: {
                return "project space code";
            }
            case METAPROJECT: {
                return "metaproject identifier";
            }
            case REGISTRATION_DATE: 
            case REGISTRATION_DATE_FROM: 
            case REGISTRATION_DATE_UNTIL: {
                return "registration_date";
            }
            case MODIFICATION_DATE: 
            case MODIFICATION_DATE_FROM: 
            case MODIFICATION_DATE_UNTIL: {
                return "modification_date";
            }
        }
        return null;
    }

    private static String getMaterialAttributeIndexField(MaterialAttributeSearchFieldKind attributeKind) {
        switch (attributeKind) {
            case CODE: {
                return "code";
            }
            case MATERIAL_TYPE: {
                return "type code";
            }
            case METAPROJECT: {
                return "metaproject identifier";
            }
            case REGISTRATION_DATE: 
            case REGISTRATION_DATE_FROM: 
            case REGISTRATION_DATE_UNTIL: {
                return "registration_date";
            }
            case MODIFICATION_DATE: 
            case MODIFICATION_DATE_FROM: 
            case MODIFICATION_DATE_UNTIL: {
                return "modification_date";
            }
        }
        return null;
    }

    private static String getSampleAttributeIndexField(SampleAttributeSearchFieldKind attributeKind) {
        switch (attributeKind) {
            case CODE: {
                return "code";
            }
            case SAMPLE_TYPE: {
                return "type code";
            }
            case PERM_ID: {
                return "perm_id";
            }
            case SPACE: {
                return "space code";
            }
            case METAPROJECT: {
                return "metaproject identifier";
            }
            case REGISTRATION_DATE: 
            case REGISTRATION_DATE_FROM: 
            case REGISTRATION_DATE_UNTIL: {
                return "registration_date";
            }
            case MODIFICATION_DATE: 
            case MODIFICATION_DATE_FROM: 
            case MODIFICATION_DATE_UNTIL: {
                return "modification_date";
            }
        }
        throw new IllegalArgumentException(attributeKind.toString());
    }
}

