/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.EntityPropertiesConverter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertiesConverter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyCalculatorFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.EntityAdaptorFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.IDynamicPropertyCalculator;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicConstant;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins.api.IEntityAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;

public class DynamicPropertyEvaluator
implements IDynamicPropertyEvaluator {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DynamicPropertyEvaluator.class);
    public static final String ERROR_PREFIX = "ERROR: ";
    private final IDynamicPropertyCalculatorFactory dynamicPropertyCalculatorFactory;
    private final List<EntityTypePropertyTypePE> evaluationPath = new ArrayList<EntityTypePropertyTypePE>();
    private EntityPropertiesConverterDelegatorFacade entityPropertiesConverter;

    public DynamicPropertyEvaluator(IDAOFactory daoFactory, EntityPropertiesConverter.IHibernateSessionProvider customSessionProviderOrNull, IDynamicPropertyCalculatorFactory dynamicPropertyCalculatorFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        assert (daoFactory != null);
        this.entityPropertiesConverter = new EntityPropertiesConverterDelegatorFacade(daoFactory, customSessionProviderOrNull, managedPropertyEvaluatorFactory);
        this.dynamicPropertyCalculatorFactory = dynamicPropertyCalculatorFactory;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends IEntityInformationWithPropertiesHolder> void evaluateProperties(T entity, Session session) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Evaluating dynamic properties of entity '%s'.", entity));
        }
        List allPropertyTypes = null;
        List existingProperties = null;
        Query propertyTypeQuery = null;
        Query propertyQuery = null;
        switch (entity.getEntityKind()) {
            case SAMPLE: {
                propertyTypeQuery = session.createQuery("SELECT sample.sampleType.sampleTypePropertyTypesInternal FROM SamplePE sample WHERE sample = :sample").setParameter("sample", entity);
                allPropertyTypes = propertyTypeQuery.list();
                propertyQuery = session.createQuery("SELECT property FROM SamplePropertyPE property WHERE property.entity = :sample AND property.entityTypePropertyType IN (:types)").setParameter("sample", entity).setParameterList("types", (Collection)allPropertyTypes);
                existingProperties = propertyQuery.list();
                break;
            }
            case DATA_SET: {
                propertyTypeQuery = session.createQuery("SELECT data.dataSetType.dataSetTypePropertyTypesInternal FROM DataPE data WHERE data = :data").setParameter("data", entity);
                allPropertyTypes = propertyTypeQuery.list();
                propertyQuery = session.createQuery("SELECT property FROM DataSetPropertyPE property WHERE property.entity = :data AND property.entityTypePropertyType IN (:types)").setParameter("data", entity).setParameterList("types", (Collection)allPropertyTypes);
                existingProperties = propertyQuery.list();
                break;
            }
            case EXPERIMENT: {
                propertyTypeQuery = session.createQuery("SELECT experiment.experimentType.experimentTypePropertyTypesInternal FROM ExperimentPE experiment WHERE experiment = :experiment").setParameter("experiment", entity);
                allPropertyTypes = propertyTypeQuery.list();
                propertyQuery = session.createQuery("SELECT property FROM ExperimentPropertyPE property WHERE property.entity = :experiment AND property.entityTypePropertyType IN (:types)").setParameter("experiment", entity).setParameterList("types", (Collection)allPropertyTypes);
                existingProperties = propertyQuery.list();
                break;
            }
            case MATERIAL: {
                propertyTypeQuery = session.createQuery("SELECT material.materialType.materialTypePropertyTypesInternal FROM MaterialPE material WHERE material = :material").setParameter("material", entity);
                allPropertyTypes = propertyTypeQuery.list();
                propertyQuery = session.createQuery("SELECT property FROM MaterialPropertyPE property WHERE property.entity = :material AND property.entityTypePropertyType IN (:types)").setParameter("material", entity).setParameterList("types", (Collection)allPropertyTypes);
                existingProperties = propertyQuery.list();
                break;
            }
            default: {
                throw new IllegalArgumentException(entity.getEntityKind().toString());
            }
        }
        for (EntityPropertyPE property : existingProperties) {
            allPropertyTypes.remove(property.getEntityTypePropertyType());
        }
        for (EntityTypePropertyTypePE etpt : allPropertyTypes) {
            void var9_9;
            if (!etpt.isDynamic()) continue;
            Object var9_10 = null;
            switch (etpt.getEntityType().getEntityKind()) {
                case SAMPLE: {
                    SamplePropertyPE samplePropertyPE = new SamplePropertyPE();
                    break;
                }
                case DATA_SET: {
                    DataSetPropertyPE dataSetPropertyPE = new DataSetPropertyPE();
                    break;
                }
                case EXPERIMENT: {
                    ExperimentPropertyPE experimentPropertyPE = new ExperimentPropertyPE();
                    break;
                }
                case MATERIAL: {
                    MaterialPropertyPE materialPropertyPE = new MaterialPropertyPE();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(etpt.getEntityType().getEntityKind().toString());
                }
            }
            var9_9.setValue(BasicConstant.DYNAMIC_PROPERTY_PLACEHOLDER_VALUE);
            var9_9.setEntityTypePropertyType(etpt);
            var9_9.setRegistrator(etpt.getRegistrator());
            var9_9.setAuthor(etpt.getRegistrator());
            entity.addProperty((EntityPropertyPE)var9_9);
        }
        IEntityAdaptor entityAdaptor = EntityAdaptorFactory.create(entity, (IDynamicPropertyEvaluator)this, session);
        HashSet<EntityPropertyPE> propertiesToRemove = new HashSet<EntityPropertyPE>();
        for (EntityPropertyPE entityPropertyPE : entity.getProperties()) {
            EntityTypePropertyTypePE etpt = entityPropertyPE.getEntityTypePropertyType();
            if (!etpt.isDynamic()) continue;
            String dynamicValue = this.evaluateProperty(entityAdaptor, etpt, true);
            String valueOrNull = null;
            MaterialPE materialOrNull = null;
            VocabularyTermPE termOrNull = null;
            if (dynamicValue == null) {
                propertiesToRemove.add(entityPropertyPE);
                continue;
            }
            if (dynamicValue.startsWith(BasicConstant.ERROR_PROPERTY_PREFIX)) {
                entityPropertyPE.setUntypedValue(dynamicValue, null, null);
                continue;
            }
            try {
                switch (etpt.getPropertyType().getType().getCode()) {
                    case CONTROLLEDVOCABULARY: {
                        termOrNull = this.entityPropertiesConverter.tryGetVocabularyTerm(dynamicValue, etpt.getPropertyType());
                        break;
                    }
                    case MATERIAL: {
                        materialOrNull = this.entityPropertiesConverter.tryGetMaterial(dynamicValue, etpt.getPropertyType());
                        break;
                    }
                    default: {
                        valueOrNull = dynamicValue;
                        break;
                    }
                }
            }
            catch (Exception ex) {
                valueOrNull = DynamicPropertyEvaluator.errorPropertyValue(ex.getMessage());
            }
            entityPropertyPE.setUntypedValue(valueOrNull, termOrNull, materialOrNull);
            if (session.contains((Object)entityPropertyPE)) continue;
            session.persist((Object)entityPropertyPE);
        }
        for (EntityPropertyPE entityPropertyPE : propertiesToRemove) {
            entityPropertyPE.getEntity().removeProperty(entityPropertyPE);
        }
    }

    @Override
    public List<EntityTypePropertyTypePE> getEvaluationPath() {
        return this.evaluationPath;
    }

    @Override
    public String evaluateProperty(IEntityAdaptor entityAdaptor, EntityTypePropertyTypePE etpt) {
        return this.evaluateProperty(entityAdaptor, etpt, false);
    }

    private String evaluateProperty(IEntityAdaptor entityAdaptor, EntityTypePropertyTypePE etpt, boolean startPath) {
        assert (etpt.isDynamic()) : "expected dynamic property";
        try {
            if (startPath) {
                this.evaluationPath.clear();
            } else {
                this.evaluationPath.add(etpt);
            }
            IDynamicPropertyCalculator calculator = this.dynamicPropertyCalculatorFactory.getCalculator(etpt);
            String dynamicValue = calculator.eval(entityAdaptor);
            String validatedValue = this.entityPropertiesConverter.tryCreateValidatedPropertyValue(etpt.getEntityType().getEntityKind(), etpt.getPropertyType(), etpt, dynamicValue);
            return validatedValue;
        }
        catch (Exception ex) {
            String errorValue = DynamicPropertyEvaluator.errorPropertyValue(ex.getMessage());
            return errorValue;
        }
    }

    public static String errorPropertyValue(String error) {
        String errorMsg = ERROR_PREFIX + error;
        operationLog.info((Object)errorMsg);
        return String.valueOf(BasicConstant.ERROR_PROPERTY_PREFIX) + errorMsg;
    }

    private static class EntityPropertiesConverterDelegatorFacade {
        final Map<EntityKind, IEntityPropertiesConverter> convertersByEntityKind = new HashMap<EntityKind, IEntityPropertiesConverter>();
        private final EntityPropertiesConverter.ComplexPropertyValueHelper complexPropertyValueHelper;

        public EntityPropertiesConverterDelegatorFacade(IDAOFactory daoFactory, EntityPropertiesConverter.IHibernateSessionProvider customSessionProviderOrNull, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
            this.complexPropertyValueHelper = new EntityPropertiesConverter.ComplexPropertyValueHelper(daoFactory, customSessionProviderOrNull);
            EntityKind[] entityKindArray = EntityKind.values();
            int n = entityKindArray.length;
            int n2 = 0;
            while (n2 < n) {
                EntityKind entityKind = entityKindArray[n2];
                this.convertersByEntityKind.put(entityKind, new EntityPropertiesConverter(entityKind, daoFactory, managedPropertyEvaluatorFactory));
                ++n2;
            }
        }

        public String tryCreateValidatedPropertyValue(EntityKind entityKind, PropertyTypePE propertyType, EntityTypePropertyTypePE entityTypePropertyType, String value) {
            return this.convertersByEntityKind.get((Object)entityKind).tryCreateValidatedPropertyValue(propertyType, entityTypePropertyType, value);
        }

        public MaterialPE tryGetMaterial(String value, PropertyTypePE propertyType) {
            return this.complexPropertyValueHelper.tryGetMaterial(value, propertyType);
        }

        public VocabularyTermPE tryGetVocabularyTerm(String value, PropertyTypePE propertyType) {
            return this.complexPropertyValueHelper.tryGetVocabularyTerm(value, propertyType);
        }
    }
}

