/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.DynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins.api.IEntityAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins.api.IEntityPropertyAdaptor;

public class DynamicPropertyAdaptor
implements IEntityPropertyAdaptor {
    private State state = State.EMPTY;
    private String value = null;
    private final String code;
    private final EntityPropertyPE propertyPE;
    private final IEntityAdaptor entityAdaptor;
    private final IDynamicPropertyEvaluator evaluator;

    public DynamicPropertyAdaptor(String code, IEntityAdaptor entityAdaptor, EntityPropertyPE propertyPE, IDynamicPropertyEvaluator evaluator) {
        this.code = code;
        this.entityAdaptor = entityAdaptor;
        this.propertyPE = propertyPE;
        this.evaluator = evaluator;
    }

    @Override
    public String valueAsString() {
        switch (this.state) {
            case EMPTY: {
                this.state = State.EVALUATING;
                this.value = this.doEvaluate();
                this.state = State.EVALUATED;
                break;
            }
            case EVALUATING: {
                StringBuilder path = new StringBuilder();
                for (EntityTypePropertyTypePE etpt : this.evaluator.getEvaluationPath()) {
                    path.append(String.valueOf(etpt.getPropertyType().getCode()) + " -> ");
                }
                path.append(this.propertyTypeCode());
                String errorMsg = String.format("cycle of dependencies found between dynamic properties: %s", path.toString());
                this.value = DynamicPropertyEvaluator.errorPropertyValue(errorMsg);
                this.state = State.EVALUATED;
                break;
            }
        }
        return this.value;
    }

    private String doEvaluate() {
        EntityTypePropertyTypePE etpt = this.propertyPE.getEntityTypePropertyType();
        return this.evaluator.evaluateProperty(this.entityAdaptor, etpt);
    }

    @Override
    public String renderedValue() {
        return this.valueAsString();
    }

    @Override
    public String propertyTypeCode() {
        return this.code;
    }

    public EntityPropertyPE getPropertyPE() {
        return this.propertyPE;
    }

    public String toString() {
        return String.valueOf(this.propertyTypeCode()) + " " + this.valueAsString();
    }

    private static enum State {
        EMPTY,
        EVALUATING,
        EVALUATED;

    }
}

