/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyCalculatorFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.JythonDynamicPropertyCalculator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.IDynamicPropertyCalculator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.IDynamicPropertyCalculatorHotDeployPlugin;
import ch.systemsx.cisd.openbis.generic.shared.IJythonEvaluatorPool;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PluginType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins.AbstractCommonPropertyBasedHotDeployPluginFactory;

public class DynamicPropertyCalculatorFactory
extends AbstractCommonPropertyBasedHotDeployPluginFactory<IDynamicPropertyCalculatorHotDeployPlugin>
implements IDynamicPropertyCalculatorFactory {
    private final IJythonEvaluatorPool evaluationRunnerProvider;

    public DynamicPropertyCalculatorFactory(String pluginDirectoryPath, IJythonEvaluatorPool evaluationRunnerProvider) {
        super(pluginDirectoryPath);
        this.evaluationRunnerProvider = evaluationRunnerProvider;
    }

    @Override
    public IDynamicPropertyCalculator getCalculator(EntityTypePropertyTypePE etpt) {
        PluginType pluginType = etpt.getScript().getPluginType();
        String script = etpt.getScript().getScript();
        String scriptName = etpt.getScript().getName();
        return this.getCalculator(pluginType, scriptName, script);
    }

    @Override
    public IDynamicPropertyCalculator getCalculator(PluginType pluginType, String scriptName, String script) {
        switch (pluginType) {
            case JYTHON: {
                return JythonDynamicPropertyCalculator.create(script, this.evaluationRunnerProvider);
            }
            case PREDEPLOYED: {
                IDynamicPropertyCalculator dynamicPropertyCalculator = (IDynamicPropertyCalculator)this.tryGetPredeployedPluginByName(scriptName);
                if (dynamicPropertyCalculator == null) {
                    throw new UserFailureException("Couldn't find plugin named '" + scriptName + "'.");
                }
                return dynamicPropertyCalculator;
            }
        }
        return null;
    }

    @Override
    protected String getPluginDescription() {
        return "dynamic property";
    }

    @Override
    protected Class<IDynamicPropertyCalculatorHotDeployPlugin> getPluginClass() {
        return IDynamicPropertyCalculatorHotDeployPlugin.class;
    }

    @Override
    protected ScriptType getScriptType() {
        return ScriptType.DYNAMIC_PROPERTY;
    }

    @Override
    protected String getDefaultPluginSubDirName() {
        return "dynamic-properties";
    }
}

