/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.ExperimentAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.ExternalDataAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.MaterialAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.SampleAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.IDataAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.IExperimentAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.IMaterialAdaptor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.ISampleAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins.api.IEntityAdaptor;
import org.hibernate.Session;

public class EntityAdaptorFactory {
    public static IEntityAdaptor create(IEntityInformationWithPropertiesHolder entity, IDynamicPropertyEvaluator evaluator, Session session) {
        switch (entity.getEntityKind()) {
            case SAMPLE: {
                return new SampleAdaptor((SamplePE)entity, evaluator, session);
            }
            case EXPERIMENT: {
                return new ExperimentAdaptor((ExperimentPE)entity, evaluator, session);
            }
            case DATA_SET: {
                return new ExternalDataAdaptor((DataPE)entity, evaluator, session);
            }
            case MATERIAL: {
                return new MaterialAdaptor((MaterialPE)entity, evaluator);
            }
        }
        throw new UnsupportedOperationException("");
    }

    public static IExperimentAdaptor create(ExperimentPE entity, IDynamicPropertyEvaluator evaluator, Session session) {
        return new ExperimentAdaptor(entity, evaluator, session);
    }

    public static ISampleAdaptor create(SamplePE entity, IDynamicPropertyEvaluator evaluator, Session session) {
        return new SampleAdaptor(entity, evaluator, session);
    }

    public static IDataAdaptor create(DataPE entity, IDynamicPropertyEvaluator evaluator, Session session) {
        return new ExternalDataAdaptor(entity, evaluator, session);
    }

    public static IMaterialAdaptor create(MaterialPE entity, IDynamicPropertyEvaluator evaluator) {
        return new MaterialAdaptor(entity, evaluator);
    }
}

