/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator;

import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.common.resource.IReleasable;
import ch.systemsx.cisd.common.resource.ReleasableIterator;
import ch.systemsx.cisd.common.resource.Resources;
import java.util.Iterator;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.ScrollableResults;

public abstract class ScrollableResultsIterator<T>
implements Iterable<T>,
IReleasable {
    private final ScrollableResults scroll;
    private ReleasableIterator<T> releasableIterator;

    public ScrollableResultsIterator(ScrollableResults scroll) {
        this.scroll = scroll;
    }

    public abstract T parseValue(Object[] var1);

    @Override
    public Iterator<T> iterator() {
        if (this.releasableIterator != null) {
            return this.releasableIterator;
        }
        this.releasableIterator = new ReleasableIterator(new Iterator<T>(){
            Object[] current = null;

            @Override
            public boolean hasNext() {
                if (this.current != null) {
                    return true;
                }
                if (ScrollableResultsIterator.this.scroll.next()) {
                    this.current = ScrollableResultsIterator.this.scroll.get();
                    return true;
                }
                return false;
            }

            @Override
            public T next() {
                if (this.current == null) {
                    if (!ScrollableResultsIterator.this.scroll.next()) {
                        return null;
                    }
                    this.current = ScrollableResultsIterator.this.scroll.get();
                }
                Object[] o = this.current;
                this.current = null;
                return ScrollableResultsIterator.this.parseValue(o);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
        return this.releasableIterator;
    }

    @Override
    public void release() {
        Resources resources = new Resources();
        if (this.scroll != null) {
            resources.add(new ScrollableResultReleasable(this.scroll));
        }
        if (this.releasableIterator != null) {
            resources.add(this.releasableIterator);
        }
        resources.release();
    }

    private static class ScrollableResultReleasable
    implements IReleasable {
        private ScrollableResults results;

        public ScrollableResultReleasable(ScrollableResults results) {
            this.results = results;
        }

        @Override
        public void release() {
            this.results.close();
        }

        public String toString() {
            ToStringBuilder builder = new ToStringBuilder((Object)this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
            return builder.toString();
        }
    }
}

