/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.migration;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.dbmigration.java.MigrationStepAdapter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public final class MigrationStepFrom023To024
extends MigrationStepAdapter {
    private static final String INSTANCE_PREFIX = "Instance_";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, MigrationStepFrom023To024.class);
    private static final ParameterizedRowMapper<DatabaseInstance> DATABASE_ROW_MAPPER = new ParameterizedRowMapper<DatabaseInstance>(){

        public final DatabaseInstance mapRow(ResultSet rs, int rowNum) throws SQLException {
            String code = rs.getString("code");
            String uuid = rs.getString("uuid");
            return new DatabaseInstance(code, uuid);
        }
    };
    private static final ParameterizedRowMapper<ExternalData> EXTERNAL_DATA_ROW_MAPPER = new ParameterizedRowMapper<ExternalData>(){

        public final ExternalData mapRow(ResultSet rs, int rowNum) throws SQLException {
            long id = rs.getLong("data_id");
            String location = rs.getString("location");
            return new ExternalData(id, location);
        }
    };

    private static final DatabaseInstance getDatabaseInstance(SimpleJdbcTemplate simpleJdbcTemplate) {
        DatabaseInstance databaseInstance = (DatabaseInstance)simpleJdbcTemplate.queryForObject(String.format("select uuid, code from %s where is_original_source = ?", "database_instances"), DATABASE_ROW_MAPPER, new Object[]{true});
        return databaseInstance;
    }

    static final String getNewLocation(ExternalData externalData, DatabaseInstance databaseInstance) {
        String location = externalData.location;
        int index = location.indexOf(47);
        if (index < 0) {
            throw new DataIntegrityViolationException(String.format("No '/' found in location of externa data '%s'.", externalData));
        }
        String afterInstance = location.substring(index);
        return INSTANCE_PREFIX + databaseInstance.uuid + afterInstance;
    }

    @Override
    public final void performPostMigration(SimpleJdbcTemplate simpleJdbcTemplate, DataSource dataSource) throws DataAccessException {
        DatabaseInstance databaseInstance = MigrationStepFrom023To024.getDatabaseInstance(simpleJdbcTemplate);
        List externalDatas = simpleJdbcTemplate.query(String.format("select data_id, location from %s where location like 'Instance_%s%%'", "external_data", databaseInstance.code), EXTERNAL_DATA_ROW_MAPPER, new Object[0]);
        if (externalDatas.size() == 0) {
            operationLog.info((Object)"No data set location has been migrated.");
        } else {
            for (ExternalData externalData : externalDatas) {
                int updated = simpleJdbcTemplate.update(String.format("update %s set location = ? where data_id = ?", "external_data"), new Object[]{MigrationStepFrom023To024.getNewLocation(externalData, databaseInstance), externalData.id});
                if (updated == 1) continue;
                throw new IncorrectResultSizeDataAccessException(1, updated);
            }
            operationLog.info((Object)String.format("Following data set locations '%s' have been migrated.", CollectionUtils.abbreviate(externalDatas, 10)));
        }
    }

    static final class DatabaseInstance {
        final String code;
        final String uuid;

        DatabaseInstance(String code, String uuid) {
            this.code = code;
            this.uuid = uuid;
        }
    }

    static final class ExternalData {
        final long id;
        final String location;

        ExternalData(long id, String location) {
            this.id = id;
            this.location = location;
        }

        public final String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        }
    }
}

