/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.migration;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.dbmigration.java.MigrationStepAdapter;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DisplaySettings;
import ch.systemsx.cisd.openbis.generic.shared.util.DisplaySettingsSerializationUtils;
import ch.systemsx.cisd.openbis.generic.shared.util.SimplePropertyValidator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public final class MigrationStepFrom046To047
extends MigrationStepAdapter {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, MigrationStepFrom046To047.class);
    private static final String SELECT_PERSON_WITH_DISPLAY_SETTINGS_QUERY = "SELECT id, user_id, display_settings FROM %s;";
    private static final ParameterizedRowMapper<PersonWithDisplaySettings> PERSON_WITH_DISPLAY_SETTINGS_ROW_MAPPER = new ParameterizedRowMapper<PersonWithDisplaySettings>(){

        public final PersonWithDisplaySettings mapRow(ResultSet rs, int rowNum) throws SQLException {
            long id = rs.getLong("id");
            String userId = rs.getString("user_id");
            byte[] serializedDisplaySettings = rs.getBytes("display_settings");
            return new PersonWithDisplaySettings(id, userId, serializedDisplaySettings);
        }
    };

    public static final String getNewDateValue(String oldDateValue) {
        return new SimplePropertyValidator.TimestampValidator().validate(oldDateValue);
    }

    @Override
    public final void performPreMigration(SimpleJdbcTemplate simpleJdbcTemplate, DataSource dataSource) throws DataAccessException {
        List persons = simpleJdbcTemplate.query(String.format(SELECT_PERSON_WITH_DISPLAY_SETTINGS_QUERY, "persons"), PERSON_WITH_DISPLAY_SETTINGS_ROW_MAPPER, new Object[0]);
        if (persons.size() == 0) {
            operationLog.info((Object)"No display settings to migrate.");
        } else {
            for (PersonWithDisplaySettings person : persons) {
                int updated = simpleJdbcTemplate.update(String.format("update %s set display_settings = ? where id = ?", "persons"), new Object[]{this.getNewSerializedDisplaySettings(person), person.id});
                if (updated == 1) continue;
                throw new IncorrectResultSizeDataAccessException(1, updated);
            }
            operationLog.info((Object)String.format("Display settings of persons with following ids '%s' have been migrated.", CollectionUtils.abbreviate(persons, 10)));
        }
    }

    private byte[] getNewSerializedDisplaySettings(PersonWithDisplaySettings person) {
        DisplaySettings displaySettings = person.getDisplaySettings();
        if (!person.userId.equals("system")) {
            displaySettings.setUseWildcardSearchMode(true);
        }
        return DisplaySettingsSerializationUtils.serializeDisplaySettings(displaySettings);
    }

    private static final class PersonWithDisplaySettings {
        private final long id;
        private final byte[] serializedDisplaySettings;
        private final String userId;

        PersonWithDisplaySettings(long id, String userId, byte[] serializedDisplaySettings) {
            this.id = id;
            this.userId = userId;
            this.serializedDisplaySettings = serializedDisplaySettings;
        }

        public DisplaySettings getDisplaySettings() {
            return DisplaySettingsSerializationUtils.deserializeOrCreateDisplaySettings(this.serializedDisplaySettings);
        }

        public final String toString() {
            return this.userId;
        }
    }
}

