/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.util;

import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.openbis.generic.shared.basic.ICodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.AuthorizationGroupPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;

public final class KeyExtractorFactory {
    private static final IKeyExtractor<String, DatabaseInstancePE> DATABASE_INSTANCE_BY_CODE_KEY_EXTRACTOR = KeyExtractorFactory.createCodeKeyExtractor();
    private static final IKeyExtractor<String, DatabaseInstancePE> DATABASE_INSTANCE_BY_UUID_KEY_EXTRACTOR = new UUIDKeyExtractor();
    private static final IKeyExtractor<Long, ExperimentPE> BASE_EXPERIMENT_BY_ID_KEY_EXTRACTOR = KeyExtractorFactory.createIdKeyExtractor();
    private static final IKeyExtractor<String, VocabularyTermPE> VOCABULARY_TERM_BY_CODE_KEY_EXTRACTOR = KeyExtractorFactory.createCodeKeyExtractor();
    private static final IKeyExtractor<String, PropertyTypePE> PROPERTY_TYPE_BY_CODE_KEY_EXTRACTOR = KeyExtractorFactory.createCodeKeyExtractor();
    private static final IKeyExtractor<Long, SamplePE> SAMPLE_BY_ID_KEY_EXTRACTOR = KeyExtractorFactory.createIdKeyExtractor();
    private static final IKeyExtractor<String, PersonPE> PERSON_BY_USER_ID_KEY_EXTRACTOR = new PersonByUserIdKeyExtractor();
    private static final IKeyExtractor<String, AuthorizationGroupPE> AUTHORIZATION_GROUP_BY_CODE_KEY_EXTRACTOR = new AuthorizationGroupByCodeKeyExtractor();
    private static final IKeyExtractor<String, MaterialPE> MATERIAL_BY_CODE_KEY_EXTRACTOR = KeyExtractorFactory.createCodeKeyExtractor();
    private static final IKeyExtractor<String, EntityTypePE> ENTITY_TYPE_BY_CODE_KEY_EXTRACTOR = KeyExtractorFactory.createCodeKeyExtractor();

    private KeyExtractorFactory() {
    }

    public static final <T extends IIdHolder> IKeyExtractor<Long, T> createIdKeyExtractor() {
        return new IdKeyExtractor();
    }

    public static final <T extends ICodeHolder> IKeyExtractor<String, T> createCodeKeyExtractor() {
        return new CodeKeyExtractor();
    }

    public static final IKeyExtractor<String, DatabaseInstancePE> getDatabaseInstanceByCodeKeyExtractor() {
        return DATABASE_INSTANCE_BY_CODE_KEY_EXTRACTOR;
    }

    public static final IKeyExtractor<String, DatabaseInstancePE> getDatabaseInstanceByUUIDKeyExtractor() {
        return DATABASE_INSTANCE_BY_UUID_KEY_EXTRACTOR;
    }

    public static final IKeyExtractor<Long, ExperimentPE> getBaseExperimentByIdKeyExtractor() {
        return BASE_EXPERIMENT_BY_ID_KEY_EXTRACTOR;
    }

    public static final IKeyExtractor<String, VocabularyTermPE> getVocabularyTermByCodeKeyExtractor() {
        return VOCABULARY_TERM_BY_CODE_KEY_EXTRACTOR;
    }

    public static final IKeyExtractor<String, PropertyTypePE> getPropertyTypeByCodeKeyExtractor() {
        return PROPERTY_TYPE_BY_CODE_KEY_EXTRACTOR;
    }

    public static final IKeyExtractor<Long, SamplePE> getSampleByIdKeyExtractor() {
        return SAMPLE_BY_ID_KEY_EXTRACTOR;
    }

    public static final IKeyExtractor<String, PersonPE> getPersonByUserIdKeyExtractor() {
        return PERSON_BY_USER_ID_KEY_EXTRACTOR;
    }

    public static final IKeyExtractor<String, AuthorizationGroupPE> getAuthorizationGroupByCodeKeyExtractor() {
        return AUTHORIZATION_GROUP_BY_CODE_KEY_EXTRACTOR;
    }

    public static final IKeyExtractor<String, EntityTypePE> getEntityTypeByCodeKeyExtractor() {
        return ENTITY_TYPE_BY_CODE_KEY_EXTRACTOR;
    }

    public static final IKeyExtractor<String, MaterialPE> getMaterialByCodeKeyExtractor() {
        return MATERIAL_BY_CODE_KEY_EXTRACTOR;
    }

    private static final class AuthorizationGroupByCodeKeyExtractor
    implements IKeyExtractor<String, AuthorizationGroupPE> {
        private AuthorizationGroupByCodeKeyExtractor() {
        }

        @Override
        public final String getKey(AuthorizationGroupPE e) {
            return e.getCode();
        }
    }

    private static final class CodeKeyExtractor<T extends ICodeHolder>
    implements IKeyExtractor<String, T> {
        private CodeKeyExtractor() {
        }

        @Override
        public final String getKey(ICodeHolder id) {
            return id.getCode();
        }
    }

    private static final class IdKeyExtractor<T extends IIdHolder>
    implements IKeyExtractor<Long, T> {
        private IdKeyExtractor() {
        }

        @Override
        public final Long getKey(IIdHolder id) {
            return id.getId();
        }
    }

    private static final class PersonByUserIdKeyExtractor
    implements IKeyExtractor<String, PersonPE> {
        private PersonByUserIdKeyExtractor() {
        }

        @Override
        public final String getKey(PersonPE e) {
            return e.getUserId();
        }
    }

    private static final class UUIDKeyExtractor
    implements IKeyExtractor<String, DatabaseInstancePE> {
        private UUIDKeyExtractor() {
        }

        @Override
        public final String getKey(DatabaseInstancePE e) {
            return e.getUuid();
        }
    }
}

