/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.jython.JythonScriptSplitter;
import ch.systemsx.cisd.common.jython.JythonUtils;
import ch.systemsx.cisd.common.jython.PythonInterpreter;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.EncapsulatedCommonServer;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.IMasterDataScriptRegistrationRunner;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.MasterDataRegistrationException;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.MasterDataRegistrationService;
import java.io.File;
import java.util.List;

public class MasterDataRegistrationScriptRunner
implements IMasterDataScriptRegistrationRunner {
    private static final String SERVICE_VARIABLE_NAME = "service";
    private final EncapsulatedCommonServer commonServer;

    public MasterDataRegistrationScriptRunner(EncapsulatedCommonServer commonServer) {
        this.commonServer = commonServer;
    }

    public void executeScript(File jythonScriptFile) throws MasterDataRegistrationException {
        this.checkValidJythonScript(jythonScriptFile);
        String scriptString = FileUtilities.loadToString(jythonScriptFile);
        String[] jythonPath = JythonUtils.getScriptDirectoryPythonPath(jythonScriptFile.getAbsolutePath());
        this.executeScript(scriptString, jythonPath);
    }

    @Override
    public void executeScript(String jythonScript, String[] jythonPath) throws MasterDataRegistrationException {
        MasterDataRegistrationService service = new MasterDataRegistrationService(this.commonServer);
        PythonInterpreter interpreter = PythonInterpreter.createIsolatedPythonInterpreter();
        interpreter.addToPath(jythonPath);
        interpreter.set(SERVICE_VARIABLE_NAME, service);
        List<String> batches = new JythonScriptSplitter().split(jythonScript);
        for (String batch : batches) {
            try {
                interpreter.exec(batch);
            }
            catch (Exception e) {
                System.err.println(e.toString());
                System.err.println("Problem is in the following code:");
                System.err.println(batch);
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
            }
        }
        service.commit();
    }

    private void checkValidJythonScript(File jythonScript) {
        if (!jythonScript.exists()) {
            throw new RuntimeException("Script file does not exist :" + jythonScript.getAbsolutePath());
        }
        if (jythonScript.isDirectory()) {
            throw new RuntimeException("Scripts must be files. It is not possible to execute directories:" + jythonScript.getAbsolutePath());
        }
        if (!jythonScript.canRead()) {
            throw new RuntimeException("No read permissions for file:" + jythonScript.getAbsolutePath());
        }
    }
}

