/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl;

import ch.systemsx.cisd.common.shared.basic.string.CommaSeparatedListBuilder;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IAbstractType;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IPropertyAssignment;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IVocabulary;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.PropertyAssignment;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.VocabularyTermImmutable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MasterDataTransactionErrors {
    private List<TransactionError> errors = new ArrayList<TransactionError>();

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public List<TransactionError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public void addTypeRegistrationError(Exception ex, IAbstractType type) {
        TypeRegistrationError error = new TypeRegistrationError(ex, type);
        this.errors.add(error);
    }

    public void addPropertyAssignmentError(Exception ex, PropertyAssignment assignment) {
        PropertyAssignmentError error = new PropertyAssignmentError(ex, assignment);
        this.errors.add(error);
    }

    public void addVocabularyRegistrationError(Exception ex, IVocabulary vocabulary) {
        VocabularyRegistrationError error = new VocabularyRegistrationError(ex, vocabulary);
        this.errors.add(error);
    }

    public void addVocabularyTermsRegistrationError(Exception ex, final List<VocabularyTerm> newTerms) {
        this.errors.add(new TransactionError(ex){

            @Override
            public String getDescription() {
                CommaSeparatedListBuilder builder = new CommaSeparatedListBuilder();
                for (VocabularyTerm term : newTerms) {
                    builder.append(term.getCode().toUpperCase());
                }
                return "Failed to register new terms [" + builder + "]: " + this.getException().getMessage();
            }
        });
    }

    public void updateVocabularyTermError(Exception ex, final VocabularyTermImmutable term) {
        this.errors.add(new TransactionError(ex){

            @Override
            public String getDescription() {
                return "Failed to update vocabulary term '" + term.getCode() + "': " + this.getException().getMessage();
            }
        });
    }

    private static class PropertyAssignmentError
    extends TransactionError {
        private final IPropertyAssignment propertyAssignment;

        PropertyAssignmentError(Exception ex, IPropertyAssignment propertyAssignment) {
            super(ex);
            this.propertyAssignment = propertyAssignment;
        }

        @Override
        public String getDescription() {
            return String.format("Failed to assign property '%s' <-> '%s': %s", this.propertyAssignment.getEntityTypeCode(), this.propertyAssignment.getPropertyTypeCode(), this.getException().getMessage());
        }
    }

    public static abstract class TransactionError {
        private final Exception exception;

        TransactionError(Exception ex) {
            this.exception = ex;
        }

        Exception getException() {
            return this.exception;
        }

        public abstract String getDescription();
    }

    private static class TypeRegistrationError
    extends TransactionError {
        private final IAbstractType type;

        TypeRegistrationError(Exception ex, IAbstractType type) {
            super(ex);
            this.type = type;
        }

        @Override
        public String getDescription() {
            return String.format("Failed to register type '%s': %s", this.type.getCode(), this.getException().getMessage());
        }
    }

    private static class VocabularyRegistrationError
    extends TransactionError {
        private final IVocabulary vocabulary;

        VocabularyRegistrationError(Exception ex, IVocabulary vocabulary) {
            super(ex);
            this.vocabulary = vocabulary;
        }

        @Override
        public String getDescription() {
            return String.format("Failed to register vocabulary '%s': %s", this.vocabulary.getCode(), this.getException().getMessage());
        }
    }
}

