/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.aopalliance.intercept.MethodInvocation;

public class MethodInvocationUtils {
    public static Method getMethod(MethodInvocation methodInvocation, Class<? extends Annotation> annotationClass) throws NoSuchMethodException {
        List<Class<? extends Annotation>> annotationList = Collections.singletonList(annotationClass);
        return MethodInvocationUtils.getMethod(methodInvocation, annotationList);
    }

    public static Method getMethod(MethodInvocation methodInvocation, List<Class<? extends Annotation>> annotationClasses) throws NoSuchMethodException {
        Class<?> targetClass;
        Object thisObject;
        Method method = methodInvocation.getMethod();
        if (!MethodInvocationUtils.hasAnnotation(method, annotationClasses) && (thisObject = methodInvocation.getThis()) != null && !(targetClass = thisObject.getClass()).isSynthetic()) {
            method = targetClass.getMethod(method.getName(), method.getParameterTypes());
        }
        return method;
    }

    private static boolean hasAnnotation(Method method, List<Class<? extends Annotation>> annotationClasses) {
        for (Class<? extends Annotation> annotationClass : annotationClasses) {
            if (method.getAnnotation(annotationClass) == null) continue;
            return true;
        }
        return false;
    }
}

