/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetKind;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityTypeInitializer;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@JsonObject(value="DataSetType")
public final class DataSetType
extends EntityType {
    private static final long serialVersionUID = 1L;
    private boolean deletionDisallowed;
    private DataSetKind dataSetKind;
    private String mainDataSetPattern;
    private String mainDataSetPath;

    public DataSetType(DataSetTypeInitializer initializer) {
        super(initializer);
        this.deletionDisallowed = initializer.isDeletionDisallowed();
        this.dataSetKind = initializer.getDataSetKind();
        this.mainDataSetPattern = initializer.getMainDataSetPattern();
        this.mainDataSetPath = initializer.getMainDataSetPath();
    }

    public boolean isDeletionDisallowed() {
        return this.deletionDisallowed;
    }

    public DataSetKind getDataSetKind() {
        return this.dataSetKind;
    }

    public String getMainDataSetPattern() {
        return this.mainDataSetPattern;
    }

    public String getMainDataSetPath() {
        return this.mainDataSetPath;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append((Object)this.getCode());
        builder.append((Object)this.getDescription());
        builder.append("deletionDisallowed", this.deletionDisallowed);
        builder.append("dataSetKind", (Object)this.dataSetKind);
        builder.append("mainDataSetPattern", (Object)this.mainDataSetPattern);
        builder.append("mainDataSetPath", (Object)this.mainDataSetPath);
        builder.append(this.getPropertyTypeGroups());
        return builder.toString();
    }

    private DataSetType() {
    }

    private void setDeletionDisallowed(boolean deletionDisallowed) {
        this.deletionDisallowed = deletionDisallowed;
    }

    private void setDataSetKind(DataSetKind dataSetKind) {
        this.dataSetKind = dataSetKind;
    }

    private void setMainDataSetPattern(String mainDataSetPattern) {
        this.mainDataSetPattern = mainDataSetPattern;
    }

    private void setMainDataSetPath(String mainDataSetPath) {
        this.mainDataSetPath = mainDataSetPath;
    }

    public static final class DataSetTypeInitializer
    extends EntityTypeInitializer {
        private boolean deletionDisallowed;
        private DataSetKind dataSetKind;
        private String mainDataSetPattern;
        private String mainDataSetPath;

        public boolean isDeletionDisallowed() {
            return this.deletionDisallowed;
        }

        public void setDeletionDisallowed(boolean deletionDisallowed) {
            this.deletionDisallowed = deletionDisallowed;
        }

        public DataSetKind getDataSetKind() {
            return this.dataSetKind;
        }

        public void setDataSetKind(DataSetKind dataSetKind) {
            this.dataSetKind = dataSetKind;
        }

        public String getMainDataSetPattern() {
            return this.mainDataSetPattern;
        }

        public void setMainDataSetPattern(String mainDataSetPattern) {
            this.mainDataSetPattern = mainDataSetPattern;
        }

        public String getMainDataSetPath() {
            return this.mainDataSetPath;
        }

        public void setMainDataSetPath(String mainDataSetPath) {
            this.mainDataSetPath = mainDataSetPath;
        }
    }
}

