/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic;

import ch.systemsx.cisd.openbis.generic.shared.basic.URLMethodWithParameters;
import ch.systemsx.cisd.openbis.generic.shared.basic.ViewMode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;

public class PermlinkUtilities {
    public static final String PERM_ID_PARAMETER_KEY = "permId";
    public static final String ENTITY_KIND_PARAMETER_KEY = "entity";
    public static final String DOWNLOAD_ATTACHMENT_ACTION = "DOWNLOAD_ATTACHMENT";
    public static final String FILE_NAME_KEY = "file";
    public static final String VERSION_KEY = "version";

    public static final String createPermlinkURL(String baseIndexURL, EntityKind entityKind, String permId) {
        URLMethodWithParameters ulrWithParameters = new URLMethodWithParameters(baseIndexURL);
        ulrWithParameters.addParameter("viewMode", ViewMode.SIMPLE.name());
        ulrWithParameters.startHistoryToken();
        ulrWithParameters.addParameter(ENTITY_KIND_PARAMETER_KEY, entityKind.name());
        ulrWithParameters.addParameter(PERM_ID_PARAMETER_KEY, permId);
        return ulrWithParameters.toString();
    }

    private static final URLMethodWithParameters createAttachmentParameters(String baseIndexURL, String fileName, Integer version) {
        URLMethodWithParameters ulrWithParameters = new URLMethodWithParameters(baseIndexURL);
        ulrWithParameters.addParameter("viewMode", ViewMode.SIMPLE.name());
        ulrWithParameters.startHistoryToken();
        ulrWithParameters.addParameter("action", DOWNLOAD_ATTACHMENT_ACTION);
        ulrWithParameters.addParameter(FILE_NAME_KEY, fileName);
        if (version != null) {
            ulrWithParameters.addParameter(VERSION_KEY, version);
        }
        return ulrWithParameters;
    }

    public static final String createAttachmentPermlinkURL(String baseIndexURL, String fileName, Integer version, AttachmentHolderKind entityKind, String permId) {
        URLMethodWithParameters ulrWithParameters = PermlinkUtilities.createAttachmentParameters(baseIndexURL, fileName, version);
        ulrWithParameters.addParameter(ENTITY_KIND_PARAMETER_KEY, entityKind.name());
        ulrWithParameters.addParameter(PERM_ID_PARAMETER_KEY, permId);
        return ulrWithParameters.toString();
    }

    public static final String createProjectAttachmentPermlinkURL(String baseIndexURL, String fileName, Integer version, String projectCode, String space) {
        URLMethodWithParameters ulrWithParameters = PermlinkUtilities.createAttachmentParameters(baseIndexURL, fileName, version);
        ulrWithParameters.addParameter(ENTITY_KIND_PARAMETER_KEY, AttachmentHolderKind.PROJECT);
        ulrWithParameters.addParameter("code", projectCode);
        ulrWithParameters.addParameter("space", space);
        return ulrWithParameters.toString();
    }

    public static final String createProjectPermlinkURL(String baseIndexURL, String projectCode, String spaceCode) {
        URLMethodWithParameters ulrWithParameters = new URLMethodWithParameters(baseIndexURL);
        ulrWithParameters.addParameter("viewMode", ViewMode.SIMPLE.name());
        ulrWithParameters.startHistoryToken();
        ulrWithParameters.addParameter(ENTITY_KIND_PARAMETER_KEY, "PROJECT");
        ulrWithParameters.addParameter("code", projectCode);
        ulrWithParameters.addParameter("space", spaceCode);
        return ulrWithParameters.toString();
    }
}

