/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.common.types.BooleanOrUnknown;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.FileFormatTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.LocatorTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.StorageFormat;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.hibernate.Location;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="external_data", uniqueConstraints={@UniqueConstraint(columnNames={"location", "loty_id"})})
@PrimaryKeyJoinColumn(name="data_id")
@Indexed(index="DataPE")
public final class ExternalDataPE
extends DataPE {
    private static final long serialVersionUID = 35L;
    public static final ExternalDataPE[] EMPTY_ARRAY = new ExternalDataPE[0];
    private String shareId;
    private String location;
    private Long size;
    private VocabularyTermPE storageFormatVocabularyTerm;
    private FileFormatTypePE fileFormatType;
    private LocatorTypePE locatorType;
    private BooleanOrUnknown complete = BooleanOrUnknown.U;
    private DataSetArchivingStatus status = DataSetArchivingStatus.AVAILABLE;
    private boolean isPresentInArchive;
    private boolean storageConfirmation = false;
    private int speedHint = -50;

    @ManyToOne(fetch=FetchType.LAZY)
    @NotNull(message="Locator type can not be null.")
    @JoinColumn(name="loty_id", updatable=false)
    public LocatorTypePE getLocatorType() {
        return this.locatorType;
    }

    public void setLocatorType(LocatorTypePE locatorType) {
        this.locatorType = locatorType;
    }

    @Column(name="location")
    @Length(max=1024, message="Given location '%s' is too long (maximal length: {max} characters).")
    @NotNull(message="Location can not be null.")
    @Location(relative=true, message="Location is not relative")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Column(name="share_id")
    public String getShareId() {
        return this.shareId;
    }

    public void setShareId(String shareId) {
        this.shareId = shareId;
    }

    @Column(name="size")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @NotNull(message="Storage format can not be null.")
    @JoinColumn(name="cvte_id_stor_fmt", updatable=false)
    public VocabularyTermPE getStorageFormatVocabularyTerm() {
        return this.storageFormatVocabularyTerm;
    }

    public void setStorageFormatVocabularyTerm(VocabularyTermPE storageFormatVocabularyTerm) {
        this.storageFormatVocabularyTerm = storageFormatVocabularyTerm;
    }

    @Transient
    public StorageFormat getStorageFormat() {
        return StorageFormat.tryGetFromCode(this.storageFormatVocabularyTerm.getCode());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @NotNull(message="File format type can not be null.")
    @JoinColumn(name="ffty_id", updatable=true)
    @IndexedEmbedded(prefix="file format type ")
    public FileFormatTypePE getFileFormatType() {
        return this.fileFormatType;
    }

    public void setFileFormatType(FileFormatTypePE fileFormatType) {
        this.fileFormatType = fileFormatType;
    }

    @NotNull(message="Complete flag can not be null.")
    @Column(name="is_complete")
    @Enumerated(value=EnumType.STRING)
    public BooleanOrUnknown getComplete() {
        return this.complete;
    }

    public void setComplete(BooleanOrUnknown complete) {
        this.complete = complete;
    }

    @NotNull(message="Status can not be null.")
    @Column(name="status")
    @Enumerated(value=EnumType.STRING)
    public DataSetArchivingStatus getStatus() {
        return this.status;
    }

    public void setStatus(DataSetArchivingStatus status) {
        this.status = status;
    }

    @Column(name="present_in_archive")
    public boolean isPresentInArchive() {
        return this.isPresentInArchive;
    }

    public void setPresentInArchive(boolean isPresentInArchive) {
        this.isPresentInArchive = isPresentInArchive;
    }

    @Column(name="storage_confirmation")
    @Field(name="storage_confirmed", index=Index.UN_TOKENIZED, store=Store.YES)
    public boolean isStorageConfirmation() {
        return this.storageConfirmation;
    }

    public void setStorageConfirmation(boolean storageConfirmation) {
        this.storageConfirmation = storageConfirmation;
    }

    @Column(name="speed_hint")
    public int getSpeedHint() {
        return this.speedHint;
    }

    public void setSpeedHint(int speedHint) {
        this.speedHint = speedHint;
    }

    @Override
    @Transient
    public boolean isAvailable() {
        return this.getStatus().isAvailable();
    }

    @Override
    @Transient
    public boolean isDeletable() {
        return this.getStatus().isDeletable();
    }
}

