/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.collection.UnmodifiableListDecorator;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PluginType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePropertyTypePE;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="scripts")
public class ScriptPE
extends HibernateAbstractRegistrationHolder
implements IIdHolder,
Comparable<ScriptPE>,
Serializable {
    private static final long serialVersionUID = 35L;
    protected Long id;
    private ScriptType scriptType;
    private PluginType pluginType;
    private String name;
    private String description;
    private DatabaseInstancePE databaseInstance;
    private String script;
    private EntityKind entityKind;
    private boolean available;
    private List<SampleTypePropertyTypePE> sampleAssignments = new ArrayList<SampleTypePropertyTypePE>();
    private List<ExperimentTypePropertyTypePE> experimentAssignments = new ArrayList<ExperimentTypePropertyTypePE>();
    private List<MaterialTypePropertyTypePE> materialAssignments = new ArrayList<MaterialTypePropertyTypePE>();
    private List<DataSetTypePropertyTypePE> dataSetAssignments = new ArrayList<DataSetTypePropertyTypePE>();
    private Date modificationDate;

    @Column(name="description")
    @Length(max=2000, message="Given description '%s' is too long (maximal length: {max} characters).")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Database instance can not be null.")
    @JoinColumn(name="dbin_id", updatable=false)
    public DatabaseInstancePE getDatabaseInstance() {
        return this.databaseInstance;
    }

    public void setDatabaseInstance(DatabaseInstancePE databaseInstance) {
        this.databaseInstance = databaseInstance;
    }

    public final void setId(Long id) {
        this.id = id;
    }

    @Override
    @SequenceGenerator(name="SCRIPT_ID_SEQ", sequenceName="SCRIPT_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SCRIPT_ID_SEQ")
    public final Long getId() {
        return this.id;
    }

    @Column(name="name")
    @NotNull(message="Name can not be null.")
    @Length(min=1, max=200, message="Given name '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Version
    @Column(name="registration_timestamp", nullable=false)
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date versionDate) {
        this.modificationDate = versionDate;
    }

    @Column(name="script")
    @Length(min=1, message="Given expression '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ScriptPE)) {
            return false;
        }
        ScriptPE that = (ScriptPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getName(), (Object)that.getName());
        builder.append((Object)this.getDatabaseInstance(), (Object)that.getDatabaseInstance());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getName());
        builder.append((Object)this.getDatabaseInstance());
        return builder.toHashCode();
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(ScriptPE that) {
        String thatName = that.getName();
        String thisName = this.getName();
        if (thisName == null) {
            return thatName == null ? 0 : -1;
        }
        if (thatName == null) {
            return 1;
        }
        return thisName.compareTo(thatName);
    }

    @Transient
    public List<EntityTypePropertyTypePE> getPropertyAssignments() {
        ArrayList<EntityTypePropertyTypePE> assignments = new ArrayList<EntityTypePropertyTypePE>();
        assignments.addAll(this.getDataSetAssignments());
        assignments.addAll(this.getExperimentAssignments());
        assignments.addAll(this.getMaterialAssignments());
        assignments.addAll(this.getSampleAssignments());
        return new UnmodifiableListDecorator<EntityTypePropertyTypePE>((List<EntityTypePropertyTypePE>)assignments);
    }

    @Deprecated
    @OneToMany(fetch=FetchType.LAZY, mappedBy="script")
    @Private
    public List<SampleTypePropertyTypePE> getSampleAssignments() {
        return this.sampleAssignments;
    }

    private void setSampleAssignments(List<SampleTypePropertyTypePE> sampleAssignments) {
        this.sampleAssignments = sampleAssignments;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="script")
    private List<ExperimentTypePropertyTypePE> getExperimentAssignments() {
        return this.experimentAssignments;
    }

    private void setExperimentAssignments(List<ExperimentTypePropertyTypePE> experimentAssignments) {
        this.experimentAssignments = experimentAssignments;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="script")
    private List<MaterialTypePropertyTypePE> getMaterialAssignments() {
        return this.materialAssignments;
    }

    private void setMaterialAssignments(List<MaterialTypePropertyTypePE> materialAssignments) {
        this.materialAssignments = materialAssignments;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="script")
    private List<DataSetTypePropertyTypePE> getDataSetAssignments() {
        return this.dataSetAssignments;
    }

    private void setDataSetAssignments(List<DataSetTypePropertyTypePE> dataSetAssignments) {
        this.dataSetAssignments = dataSetAssignments;
    }

    @Column(name="entity_kind")
    @Enumerated(value=EnumType.STRING)
    public EntityKind getEntityKind() {
        return this.entityKind;
    }

    public void setEntityKind(EntityKind entityKind) {
        this.entityKind = entityKind;
    }

    @NotNull(message="Script Type can not be null.")
    @Column(name="script_type")
    @Enumerated(value=EnumType.STRING)
    public ScriptType getScriptType() {
        return this.scriptType;
    }

    public void setScriptType(ScriptType scriptType) {
        this.scriptType = scriptType;
    }

    @NotNull(message="Plugin Type can not be null.")
    @Column(name="plugin_type")
    @Enumerated(value=EnumType.STRING)
    public PluginType getPluginType() {
        return this.pluginType;
    }

    public void setPluginType(PluginType pluginType) {
        this.pluginType = pluginType;
    }

    @NotNull(message="Is Available can not be null.")
    @Column(name="is_available")
    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    @Transient
    public boolean isDynamic() {
        return this.scriptType == ScriptType.DYNAMIC_PROPERTY;
    }

    @Transient
    public boolean isManaged() {
        return this.scriptType == ScriptType.MANAGED_PROPERTY;
    }
}

