/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.collection.UnmodifiableSetDecorator;
import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="controlled_vocabularies", uniqueConstraints={@UniqueConstraint(columnNames={"code", "is_internal_namespace", "dbin_id"})})
public class VocabularyPE
extends HibernateAbstractRegistrationHolder
implements IIdAndCodeHolder,
Comparable<VocabularyPE>,
Serializable {
    public static final VocabularyPE[] EMPTY_ARRAY = new VocabularyPE[0];
    private static final long serialVersionUID = 35L;
    private transient Long id;
    private String simpleCode;
    private String description;
    private Set<VocabularyTermPE> terms = new LinkedHashSet<VocabularyTermPE>();
    private boolean managedInternally;
    private boolean internalNamespace;
    private boolean chosenFromList;
    private String urlTemplate;
    private DatabaseInstancePE databaseInstance;
    private Date modificationDate;
    private List<PropertyTypePE> propertyTypes = new ArrayList<PropertyTypePE>();

    @Column(name="code")
    @NotNull(message="Code can not be null.")
    @Length(min=1, max=60, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regexp="^[A-Z0-9_\\-\\.]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    private String getSimpleCode() {
        return this.simpleCode;
    }

    private void setSimpleCode(String simpleCode) {
        this.simpleCode = simpleCode;
    }

    @Version
    @Column(name="modification_timestamp", nullable=false)
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date versionDate) {
        this.modificationDate = versionDate;
    }

    @Column(name="is_chosen_from_list")
    public boolean isChosenFromList() {
        return this.chosenFromList;
    }

    public void setChosenFromList(boolean chosenFromList) {
        this.chosenFromList = chosenFromList;
    }

    @Column(name="source_uri", updatable=true)
    public String getURLTemplate() {
        return this.urlTemplate;
    }

    public void setURLTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
    }

    @Column(name="description")
    @Length(max=2000, message="Given description '%s' is too long (maximal length: {max} characters).")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String descriptionOrNull) {
        this.description = descriptionOrNull;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Database instance can not be null.")
    @JoinColumn(name="dbin_id", updatable=false)
    public DatabaseInstancePE getDatabaseInstance() {
        return this.databaseInstance;
    }

    public void setDatabaseInstance(DatabaseInstancePE databaseInstance) {
        this.databaseInstance = databaseInstance;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="vocabularyInternal", orphanRemoval=true)
    private Set<VocabularyTermPE> getVocabularyTerms() {
        return this.terms;
    }

    private void setVocabularyTerms(Set<VocabularyTermPE> terms) {
        this.terms = terms;
    }

    @Transient
    public Set<VocabularyTermPE> getTerms() {
        return new UnmodifiableSetDecorator<VocabularyTermPE>(this.getVocabularyTerms());
    }

    public final void setTerms(Iterable<VocabularyTermPE> terms) {
        this.getVocabularyTerms().clear();
        for (VocabularyTermPE child : terms) {
            this.addTerm(child);
        }
    }

    public void addTerm(VocabularyTermPE child) {
        VocabularyPE parent = child.getVocabulary();
        if (parent != null) {
            parent.getVocabularyTerms().remove(child);
        }
        child.setVocabularyInternal(this);
        this.getVocabularyTerms().add(child);
    }

    void removeTerm(VocabularyTermPE child) {
        if (!this.equals(child.getVocabulary())) {
            throw new IllegalArgumentException("Not a term of this vocabulary: " + child);
        }
        this.getVocabularyTerms().remove(child);
    }

    @Override
    @SequenceGenerator(name="CONTROLLED_VOCABULARY_ID_SEQ", sequenceName="CONTROLLED_VOCABULARY_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CONTROLLED_VOCABULARY_ID_SEQ")
    public final Long getId() {
        return this.id;
    }

    @Column(name="is_managed_internally", nullable=false)
    public boolean isManagedInternally() {
        return this.managedInternally;
    }

    public void setManagedInternally(boolean managedInternally) {
        this.managedInternally = managedInternally;
    }

    @Column(name="is_internal_namespace", nullable=false)
    public boolean isInternalNamespace() {
        return this.internalNamespace;
    }

    public void setInternalNamespace(boolean internalNamespace) {
        this.internalNamespace = internalNamespace;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setCode(String fullCode) {
        this.setInternalNamespace(CodeConverter.isInternalNamespace(fullCode));
        this.setSimpleCode(CodeConverter.tryToDatabase(fullCode));
    }

    @Override
    @Transient
    public String getCode() {
        return CodeConverter.tryToBusinessLayer(this.getSimpleCode(), this.isInternalNamespace());
    }

    public final VocabularyTermPE tryGetVocabularyTerm(String code) {
        assert (code != null) : "Unspecified code";
        for (VocabularyTermPE vocabularyTermPE : this.getTerms()) {
            if (!vocabularyTermPE.getCode().equals(code)) continue;
            return vocabularyTermPE;
        }
        return null;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VocabularyPE)) {
            return false;
        }
        VocabularyPE that = (VocabularyPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getCode(), (Object)that.getCode());
        builder.append(this.isInternalNamespace(), that.isInternalNamespace());
        builder.append((Object)this.getDatabaseInstance(), (Object)that.getDatabaseInstance());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        builder.append(this.isInternalNamespace());
        builder.append((Object)this.getDatabaseInstance());
        return builder.toHashCode();
    }

    public final String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        builder.append("simpleCode", (Object)this.getSimpleCode());
        builder.append("internalNamespace", this.isInternalNamespace());
        builder.append("managedInternally", this.isManagedInternally());
        return builder.toString();
    }

    @Override
    public final int compareTo(VocabularyPE o) {
        return AbstractIdAndCodeHolder.compare(this, o);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="vocabulary")
    @Private
    public List<PropertyTypePE> getPropertyTypes() {
        return this.propertyTypes;
    }

    private void setPropertyTypes(List<PropertyTypePE> propertyTypes) {
        this.propertyTypes = propertyTypes;
    }
}

