/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.util.ArrayList;
import java.util.List;

public class SimpleDataSetHelper {
    public static final List<SimpleDataSetInformationDTO> filterAndTranslate(List<AbstractExternalData> externalData) {
        if (externalData == null) {
            return null;
        }
        ArrayList<SimpleDataSetInformationDTO> result = new ArrayList<SimpleDataSetInformationDTO>();
        for (AbstractExternalData ed : externalData) {
            if (!(ed instanceof PhysicalDataSet)) continue;
            PhysicalDataSet dataSet = (PhysicalDataSet)ed;
            result.add(SimpleDataSetHelper.translate(dataSet));
        }
        return result;
    }

    private static SimpleDataSetInformationDTO translate(PhysicalDataSet data) {
        SimpleDataSetInformationDTO result = new SimpleDataSetInformationDTO();
        result.setDataStoreCode(data.getDataStore().getCode());
        result.setDataSetCode(data.getCode());
        result.setRegistrationTimestamp(data.getRegistrationDate());
        result.setSpeedHint(data.getSpeedHint());
        result.setDataSetShareId(data.getShareId());
        result.setDataSetLocation(data.getLocation());
        result.setDataSetSize(data.getSize());
        result.setDatabaseInstanceCode(data.getExperiment().getProject().getSpace().getInstance().getCode());
        result.setExperimentCode(data.getExperiment().getCode());
        result.setProjectCode(data.getExperiment().getProject().getCode());
        result.setSpaceCode(data.getExperiment().getProject().getSpace().getCode());
        result.setSampleCode(data.getSampleCode());
        result.setDataSetType(data.getDataSetType().getCode());
        result.setDataStoreUrl(data.getDataStore().getHostUrl());
        result.setOrderInContainer(data.getOrderInContainer());
        return result;
    }

    public static SimpleDataSetInformationDTO translate(DatasetDescription datasetDescription) {
        SimpleDataSetInformationDTO result = new SimpleDataSetInformationDTO();
        result.setDatabaseInstanceCode(datasetDescription.getDatabaseInstanceCode());
        result.setDataSetCode(datasetDescription.getDataSetCode());
        result.setRegistrationTimestamp(datasetDescription.getRegistrationTimestamp());
        result.setSpeedHint(datasetDescription.getSpeedHint());
        result.setDataSetLocation(datasetDescription.getDataSetLocation());
        result.setDataSetSize(datasetDescription.getDataSetSize());
        result.setDataSetType(datasetDescription.getDataSetTypeCode());
        result.setExperimentCode(datasetDescription.getExperimentCode());
        result.setSpaceCode(datasetDescription.getSpaceCode());
        result.setProjectCode(datasetDescription.getProjectCode());
        result.setSampleCode(datasetDescription.getSampleCode());
        result.setOrderInContainer(datasetDescription.getOrderInContainer());
        return result;
    }
}

