/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.dataset;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.SampleTypeDisplayID;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetParentsArea;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetsArea;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetsContainedArea;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.FileFormatTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CheckBoxField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CodeField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ExperimentChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.SampleChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DataSetUpdates;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetRelationshipRole;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.AbstractGenericEntityRegistrationForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.dataset.DataSetPropertyEditor;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.PropertiesEditor;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class GenericDataSetEditForm
extends AbstractGenericEntityRegistrationForm<DataSetType, DataSetTypePropertyType> {
    private static final String SAMPLE_FIELD_ID_SUFFIX = "sample_field";
    private static final String EXPERIMENT_FIELD_ID_SUFFIX = "experiment_field";
    private final String simpleId;
    private CheckBoxField connectedWithSampleCheckbox;
    private DataSetsArea parentsArea;
    private SampleChooserField.SampleChooserFieldAdaptor sampleChooser;
    private ExperimentChooserField.ExperimentChooserFieldAdaptor experimentChooser;
    private AbstractExternalData originalDataSet;
    private IDataSetEditorBuilder builder;

    public static DatabaseModificationAwareComponent create(IViewContext<IGenericClientServiceAsync> viewContext, IIdAndCodeHolder identifiable) {
        GenericDataSetEditForm form = new GenericDataSetEditForm(viewContext, identifiable);
        return new DatabaseModificationAwareComponent((Component)form, (IDatabaseModificationObserver)form);
    }

    private GenericDataSetEditForm(IViewContext<IGenericClientServiceAsync> viewContext, IIdAndCodeHolder identifiable) {
        super(viewContext, null, identifiable, EntityKind.DATA_SET);
        this.setRevertButtonVisible(true);
        this.simpleId = GenericDataSetEditForm.createSimpleId(identifiable, EntityKind.DATA_SET);
    }

    private String createChildId(String childSuffix) {
        return String.valueOf(this.getId()) + childSuffix;
    }

    @Override
    public final void submitValidForm() {
        ((IGenericClientServiceAsync)this.viewContext.getService()).updateDataSet(this.createUpdates(), new UpdateDataSetCallback(this.viewContext));
    }

    private DataSetUpdates createUpdates() {
        DataSetUpdates result = new DataSetUpdates();
        result.setDatasetId(this.techIdOrNull);
        result.setProperties(this.extractProperties());
        result.setVersion(this.originalDataSet.getVersion());
        if (this.isConnectedWithSample().booleanValue()) {
            result.setSampleIdentifierOrNull(this.extractSampleIdentifier());
        } else {
            result.setExperimentIdentifierOrNull(this.extractExperimentIdentifier());
        }
        result.setModifiedParentDatasetCodesOrNull(this.extractParentDatasetCodes());
        result.setMetaprojectsOrNull(this.metaprojectArea.tryGetModifiedMetaprojects());
        this.builder.fillUpdates(result);
        return result;
    }

    private Boolean isConnectedWithSample() {
        return this.connectedWithSampleCheckbox.getValue();
    }

    private String extractSampleIdentifier() {
        return this.sampleChooser.getValue();
    }

    private String extractExperimentIdentifier() {
        ExperimentIdentifier identifierOrNull = this.experimentChooser.tryToGetValue();
        return identifierOrNull == null ? null : identifierOrNull.getIdentifier();
    }

    private String[] extractParentDatasetCodes() {
        return this.parentsArea.tryGetModifiedDataSetCodes();
    }

    private void updateOriginalValues(DataSetUpdateResult result) {
        this.originalDataSet.setVersion(result.getVersion());
        this.updatePropertyFieldsOriginalValues();
        List<String> parentCodes = result.getParentCodes();
        this.parentsArea.setDataSetCodes(parentCodes);
        this.connectedWithSampleCheckbox.updateOriginalValue(this.connectedWithSampleCheckbox.getValue());
        this.sampleChooser.updateOriginalValue();
        this.experimentChooser.updateOriginalValue();
        this.updateFieldOriginalValue(this.metaprojectArea);
        this.builder.updateOriginalValues(result);
    }

    @Override
    protected PropertiesEditor<DataSetType, DataSetTypePropertyType> createPropertiesEditor(String id, Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions, IViewContext<ICommonClientServiceAsync> context) {
        DataSetPropertyEditor editor = new DataSetPropertyEditor(id, inputWidgetDescriptions, context);
        return editor;
    }

    @Override
    protected List<DatabaseModificationAwareField<?>> getEntitySpecificFormFields() {
        ArrayList fields = new ArrayList();
        fields.add(DatabaseModificationAwareField.wrapUnaware(this.connectedWithSampleCheckbox));
        fields.add(DatabaseModificationAwareField.wrapUnaware(this.sampleChooser.getField()));
        fields.add(DatabaseModificationAwareField.wrapUnaware(this.experimentChooser.getField()));
        fields.add(DatabaseModificationAwareField.wrapUnaware(this.parentsArea));
        this.builder.addEntitySpecificFormFields(fields);
        return fields;
    }

    @Override
    protected void createEntitySpecificFormFields() {
        this.connectedWithSampleCheckbox = this.createConnectedWithSampleCheckbox();
        this.sampleChooser = this.createSampleField();
        this.experimentChooser = this.createExperimentChooserField();
        this.parentsArea = this.createParentsArea();
        this.builder.createEntitySpecificFormFields();
    }

    private CheckBoxField createConnectedWithSampleCheckbox() {
        CheckBoxField result = new CheckBoxField("Connected with Sample", false);
        result.addListener(Events.Change, (Listener)new Listener<FieldEvent>(){

            public void handleEvent(FieldEvent be) {
                GenericDataSetEditForm.this.updateFieldsVisibility();
            }
        });
        return result;
    }

    private SampleChooserField.SampleChooserFieldAdaptor createSampleField() {
        String label = this.viewContext.getMessage("sample", new Object[0]);
        String originalSampleOrNull = this.originalDataSet.getSampleIdentifier();
        SampleChooserField.SampleChooserFieldAdaptor result = SampleChooserField.create(label, true, originalSampleOrNull, false, false, true, this.viewContext.getCommonViewContext(), SampleTypeDisplayID.DATA_SET_EDIT_SAMPLE_CHOOSER, false);
        result.getField().setId(this.createChildId(SAMPLE_FIELD_ID_SUFFIX));
        return result;
    }

    private ExperimentChooserField.ExperimentChooserFieldAdaptor createExperimentChooserField() {
        String label = this.viewContext.getMessage("experiment", new Object[0]);
        ExperimentIdentifier originalExperiment = ExperimentIdentifier.createIdentifier(this.originalDataSet.getExperiment());
        ExperimentChooserField.ExperimentChooserFieldAdaptor result = ExperimentChooserField.create(label, true, originalExperiment, this.viewContext.getCommonViewContext());
        result.getField().setId(this.createChildId(EXPERIMENT_FIELD_ID_SUFFIX));
        return result;
    }

    private DataSetsArea createParentsArea() {
        return new DataSetParentsArea(this.viewContext, this.simpleId);
    }

    private FileFormatTypeSelectionWidget createFileFormatTypeField() {
        FileFormatTypeSelectionWidget result = new FileFormatTypeSelectionWidget(this.viewContext.getCommonViewContext(), this.getId());
        FieldUtil.markAsMandatory(result);
        return result;
    }

    @Override
    protected void initializeFormFields() {
        boolean connectedWithSample = !StringUtils.isBlank(this.sampleChooser.getValue());
        this.connectedWithSampleCheckbox.setValue(connectedWithSample);
        this.updateFieldsVisibility();
        this.propertiesEditor.initWithProperties(this.originalDataSet.getDataSetType().getAssignedPropertyTypes(), this.originalDataSet.getProperties());
        this.codeField.setValue(this.originalDataSet.getCode());
        this.metaprojectArea.setMetaprojects(this.originalDataSet.getMetaprojects());
        this.parentsArea.setValue(this.viewContext.getMessage("load_in_progress", new Object[0]));
        this.builder.initializeFormFields();
        this.loadDataInBackground();
    }

    private void loadDataInBackground() {
        DefaultResultSetConfig<String, TableModelRowWithObject<AbstractExternalData>> config = DefaultResultSetConfig.createFetchAll();
        this.viewContext.getCommonService().listDataSetRelationships(this.techIdOrNull, DataSetRelationshipRole.CHILD, config, new ListParentsCallback(this.viewContext));
        this.builder.loadDataInBackground(new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                GenericDataSetEditForm.this.updateDirtyCheck();
            }
        });
    }

    private void updateFieldsVisibility() {
        boolean connectedWithSample = this.isConnectedWithSample();
        FieldUtil.setVisibility(connectedWithSample, this.sampleChooser.getField());
        FieldUtil.setVisibility(!connectedWithSample, this.experimentChooser.getField());
    }

    private void setOriginalData(AbstractExternalData data) {
        this.originalDataSet = data;
        this.builder = data.isContainer() ? new ContainerDataSetEditFormBuilder(data.tryGetAsContainerDataSet()) : (data.isLinkData() ? new LinkDataSetEditFormBuilder(data.tryGetAsLinkDataSet()) : new ExternalDataEditFormBuilder(data.tryGetAsDataSet()));
    }

    @Override
    protected void loadForm() {
        ((IGenericClientServiceAsync)this.viewContext.getService()).getDataSetInfo(this.techIdOrNull, new DataSetInfoCallback(this.viewContext));
    }

    private List<AbstractExternalData> extractDataSets(List<TableModelRowWithObject<AbstractExternalData>> rows) {
        ArrayList<AbstractExternalData> dataSets = new ArrayList<AbstractExternalData>();
        for (TableModelRowWithObject<AbstractExternalData> row : rows) {
            dataSets.add(row.getObjectOrNull());
        }
        return dataSets;
    }

    private class ContainerDataSetEditFormBuilder
    implements IDataSetEditorBuilder {
        private DataSetsArea containedArea;

        public ContainerDataSetEditFormBuilder(ContainerDataSet dataSet) {
        }

        @Override
        public void createEntitySpecificFormFields() {
            this.containedArea = this.createContainsArea();
        }

        private DataSetsArea createContainsArea() {
            return new DataSetsContainedArea(GenericDataSetEditForm.this.viewContext, GenericDataSetEditForm.this.simpleId);
        }

        @Override
        public void updateOriginalValues(DataSetUpdateResult result) {
            List<String> containedCodes = result.getContainedDataSetCodes();
            this.containedArea.setDataSetCodes(containedCodes);
        }

        @Override
        public void fillUpdates(DataSetUpdates result) {
            result.setModifiedContainedDatasetCodesOrNull(this.extractContainedDatasetCodes());
        }

        private String[] extractContainedDatasetCodes() {
            return this.containedArea.tryGetModifiedDataSetCodes();
        }

        @Override
        public void addEntitySpecificFormFields(List<DatabaseModificationAwareField<?>> fields) {
            fields.add(DatabaseModificationAwareField.wrapUnaware(this.containedArea));
        }

        @Override
        public void initializeFormFields() {
            this.containedArea.setValue(GenericDataSetEditForm.this.viewContext.getMessage("load_in_progress", new Object[0]));
        }

        @Override
        public void loadDataInBackground(Listener<BaseEvent> listener) {
            DefaultResultSetConfig<String, TableModelRowWithObject<AbstractExternalData>> config = DefaultResultSetConfig.createFetchAll();
            GenericDataSetEditForm.this.viewContext.getCommonService().listDataSetRelationships(GenericDataSetEditForm.this.techIdOrNull, DataSetRelationshipRole.CONTAINER, config, new ListContainedDataSetsCallback(GenericDataSetEditForm.this.viewContext, listener));
        }

        private class ListContainedDataSetsCallback
        extends AbstractAsyncCallback<TypedTableResultSet<AbstractExternalData>> {
            private Listener<BaseEvent> listener;

            public ListContainedDataSetsCallback(IViewContext<?> viewContext, Listener<BaseEvent> listener) {
                super(viewContext);
                this.listener = listener;
            }

            @Override
            protected void process(TypedTableResultSet<AbstractExternalData> result) {
                List<TableModelRowWithObject<AbstractExternalData>> rows = result.getResultSet().getList().extractOriginalObjects();
                ContainerDataSetEditFormBuilder.this.containedArea.setDataSets(GenericDataSetEditForm.this.extractDataSets(rows));
                this.listener.handleEvent(null);
                if (ContainerDataSetEditFormBuilder.this.containedArea.isVisible()) {
                    ContainerDataSetEditFormBuilder.this.containedArea.setEnabled(true);
                }
            }
        }
    }

    private final class DataSetInfoCallback
    extends AbstractAsyncCallback<AbstractExternalData> {
        private DataSetInfoCallback(IViewContext<IGenericClientServiceAsync> viewContext) {
            super(viewContext);
        }

        @Override
        protected final void process(AbstractExternalData result) {
            GenericDataSetEditForm.this.setOriginalData(result);
            GenericDataSetEditForm.this.initGUI();
        }
    }

    private class ExternalDataEditFormBuilder
    implements IDataSetEditorBuilder {
        private PhysicalDataSet dataSet;
        private FileFormatTypeSelectionWidget fileFormatTypeSelectionWidget;

        public ExternalDataEditFormBuilder(PhysicalDataSet dataSet) {
            this.dataSet = dataSet;
        }

        @Override
        public void createEntitySpecificFormFields() {
            this.fileFormatTypeSelectionWidget = GenericDataSetEditForm.this.createFileFormatTypeField();
        }

        @Override
        public void updateOriginalValues(DataSetUpdateResult result) {
            this.fileFormatTypeSelectionWidget.updateOriginalValue((Object)((FileFormatTypeSelectionWidget.FileFormatTypeModel)((Object)this.fileFormatTypeSelectionWidget.getValue())));
        }

        @Override
        public void fillUpdates(DataSetUpdates result) {
            result.setFileFormatTypeCode(this.extractFileFormatTypeCode());
        }

        private String extractFileFormatTypeCode() {
            return this.fileFormatTypeSelectionWidget.tryGetSelectedFileFormatType().getCode();
        }

        @Override
        public void addEntitySpecificFormFields(List<DatabaseModificationAwareField<?>> fields) {
            fields.add(DatabaseModificationAwareField.wrapUnaware(this.fileFormatTypeSelectionWidget));
        }

        @Override
        public void initializeFormFields() {
            this.fileFormatTypeSelectionWidget.setValue((ModelData)new FileFormatTypeSelectionWidget.FileFormatTypeModel(this.dataSet.getFileFormatType()));
        }

        @Override
        public void loadDataInBackground(Listener<BaseEvent> listener) {
        }
    }

    static interface IDataSetEditorBuilder {
        public void updateOriginalValues(DataSetUpdateResult var1);

        public void loadDataInBackground(Listener<BaseEvent> var1);

        public void fillUpdates(DataSetUpdates var1);

        public void addEntitySpecificFormFields(List<DatabaseModificationAwareField<?>> var1);

        public void createEntitySpecificFormFields();

        public void initializeFormFields();
    }

    private class LinkDataSetEditFormBuilder
    implements IDataSetEditorBuilder {
        private LinkDataSet dataSet;
        private CodeField externalCodeField;

        public LinkDataSetEditFormBuilder(LinkDataSet dataSet) {
            this.dataSet = dataSet;
        }

        @Override
        public void createEntitySpecificFormFields() {
            this.externalCodeField = new CodeField(GenericDataSetEditForm.this.viewContext, GenericDataSetEditForm.this.viewContext.getMessage("external_code", new Object[0]));
            this.externalCodeField.setId(String.valueOf(GenericDataSetEditForm.this.getId()) + "_externalCode");
            this.externalCodeField.setReadOnly(true);
            this.externalCodeField.setHideTrigger(true);
            this.externalCodeField.disable();
        }

        @Override
        public void updateOriginalValues(DataSetUpdateResult result) {
        }

        @Override
        public void fillUpdates(DataSetUpdates result) {
        }

        @Override
        public void addEntitySpecificFormFields(List<DatabaseModificationAwareField<?>> fields) {
            fields.add(0, DatabaseModificationAwareField.wrapUnaware(this.externalCodeField));
        }

        @Override
        public void initializeFormFields() {
            this.externalCodeField.setValue(StringEscapeUtils.unescapeHtml(this.dataSet.getExternalCode()));
        }

        @Override
        public void loadDataInBackground(Listener<BaseEvent> listener) {
        }
    }

    private class ListParentsCallback
    extends AbstractAsyncCallback<TypedTableResultSet<AbstractExternalData>> {
        public ListParentsCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(TypedTableResultSet<AbstractExternalData> result) {
            List<TableModelRowWithObject<AbstractExternalData>> rows = result.getResultSet().getList().extractOriginalObjects();
            List dataSets = GenericDataSetEditForm.this.extractDataSets(rows);
            GenericDataSetEditForm.this.parentsArea.setDataSets(dataSets);
            GenericDataSetEditForm.this.updateDirtyCheck();
            if (GenericDataSetEditForm.this.parentsArea.isVisible()) {
                GenericDataSetEditForm.this.parentsArea.setEnabled(true);
            }
        }
    }

    public final class UpdateDataSetCallback
    extends AbstractRegistrationForm.AbstractRegistrationCallback<DataSetUpdateResult> {
        UpdateDataSetCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(DataSetUpdateResult result) {
            GenericDataSetEditForm.this.updateOriginalValues(result);
            super.process(result);
        }

        @Override
        protected String createSuccessfullRegistrationInfo(DataSetUpdateResult result) {
            return "Data set successfully updated";
        }
    }
}

