/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.AbstractExternalDataGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDirectlyConnectedController;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;

public class ExperimentDataSetBrowser
extends AbstractExternalDataGrid {
    private static final String PREFIX = "experiment-data-section_";
    public static final String ID_PREFIX = "openbis_experiment-data-section_";
    private final TechId experimentId;
    private final IDirectlyConnectedController connectionTypeProvider;

    static IDisposableComponent create(IViewContext<?> viewContext, TechId experimentId, final BasicEntityType experimentType, IDirectlyConnectedController connectionTypeProvider) {
        IViewContext<ICommonClientServiceAsync> commonViewContext = viewContext.getCommonViewContext();
        ExperimentDataSetBrowser browser = new ExperimentDataSetBrowser(commonViewContext, experimentId, connectionTypeProvider){

            @Override
            public String getGridDisplayTypeID() {
                return String.valueOf(super.getGridDisplayTypeID()) + "-" + experimentType.getCode();
            }
        };
        return browser.asDisposableWithoutToolbar();
    }

    private ExperimentDataSetBrowser(IViewContext<ICommonClientServiceAsync> viewContext, TechId experimentId, IDirectlyConnectedController connectionTypeProvider) {
        super(viewContext, ExperimentDataSetBrowser.createBrowserId(experimentId), ExperimentDataSetBrowser.createGridId(experimentId), DisplayTypeIDGenerator.EXPERIMENT_DETAILS_GRID);
        this.experimentId = experimentId;
        this.connectionTypeProvider = connectionTypeProvider;
        connectionTypeProvider.setOnChangeAction(new IDelegatedAction(){

            @Override
            public void execute() {
                ExperimentDataSetBrowser.this.refresh();
            }
        });
    }

    public static String createGridId(TechId experimentId) {
        return String.valueOf(ExperimentDataSetBrowser.createBrowserId(experimentId)) + "-grid";
    }

    public static String createBrowserId(TechId experimentId) {
        return ID_PREFIX + experimentId;
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<AbstractExternalData>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<AbstractExternalData>> callback) {
        boolean onlyDirectlyConnected = this.connectionTypeProvider.isOnlyDirectlyConnected();
        ((ICommonClientServiceAsync)this.viewContext.getService()).listExperimentDataSets(this.experimentId, resultSetConfig, onlyDirectlyConnected, callback);
    }

    /* synthetic */ ExperimentDataSetBrowser(IViewContext iViewContext, TechId techId, IDirectlyConnectedController iDirectlyConnectedController, ExperimentDataSetBrowser experimentDataSetBrowser) {
        this((IViewContext<ICommonClientServiceAsync>)iViewContext, techId, iDirectlyConnectedController);
    }
}

