/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.managed_property.ManagedPropertyFormHelper;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.HiddenField;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ManagedPropertyField
extends HiddenField<List<Map<String, String>>> {
    private static final int SPACING = 3;
    private final IViewContext<?> viewContext;
    private final List<IManagedInputWidgetDescription> widgetDescriptions;
    private final VerticalPanel verticalPanel;
    private List<Section> sections = new ArrayList<Section>();

    public ManagedPropertyField(IViewContext<?> viewContext, String label, boolean isMandatory, List<IManagedInputWidgetDescription> widgetDescriptions) {
        this.viewContext = viewContext;
        this.widgetDescriptions = widgetDescriptions;
        this.verticalPanel = new VerticalPanel();
        this.verticalPanel.setHorizontalAlign(Style.HorizontalAlignment.RIGHT);
        this.init();
    }

    private void init() {
        Button addButton = new Button("Add More");
        addButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                ManagedPropertyField.this.addNewSection(ManagedPropertyField.this.sections.size());
            }
        });
        addButton.setToolTip("Add a new section.");
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        horizontalPanel.setSpacing(3);
        horizontalPanel.add((Widget)addButton);
        this.verticalPanel.add((Widget)horizontalPanel);
        this.addNewSection(0);
    }

    public Widget getWidget() {
        return this.verticalPanel;
    }

    public void reset() {
        this.sections.clear();
        this.verticalPanel.removeAll();
        this.init();
        super.reset();
    }

    public List<Map<String, String>> getValue() {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (Section section : this.sections) {
            HashMap<String, String> row = new HashMap<String, String>();
            for (Map.Entry entry : section.inputFields.entrySet()) {
                row.put((String)entry.getKey(), ((TextField)entry.getValue()).getRawValue());
            }
            list.add(row);
        }
        return list;
    }

    private void addNewSection(int sectionIndex) {
        FormPanel formPanel = new FormPanel();
        formPanel.setWidth(630);
        formPanel.setLabelWidth(95);
        formPanel.setFieldWidth(500);
        formPanel.setHeaderVisible(false);
        HashMap inputFieldsByCode = new HashMap();
        ManagedPropertyFormHelper formHelper = new ManagedPropertyFormHelper(this.viewContext, formPanel, inputFieldsByCode);
        formHelper.fillForm(this.widgetDescriptions);
        final HorizontalPanel horizontalPanel = new HorizontalPanel();
        horizontalPanel.setSpacing(3);
        horizontalPanel.add((Widget)formPanel);
        final Section section = new Section(inputFieldsByCode);
        Button addBeforeButton = new Button("+");
        addBeforeButton.setToolTip("Add a new section before this section.");
        addBeforeButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                int index = ManagedPropertyField.this.sections.indexOf(section);
                ManagedPropertyField.this.addNewSection(index);
            }
        });
        horizontalPanel.add((Widget)addBeforeButton);
        Button removeButton = new Button("-");
        removeButton.setToolTip("Delete this section.");
        removeButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                MessageBox.confirm((String)"Delete Section", (String)"Do you really want to delete this section?", (Listener)new Listener<MessageBoxEvent>(){

                    public void handleEvent(MessageBoxEvent be) {
                        Button buttonClicked = be.getButtonClicked();
                        if ("yes".equals(buttonClicked.getItemId())) {
                            ManagedPropertyField.this.sections.remove(section);
                            ManagedPropertyField.this.verticalPanel.remove((Widget)horizontalPanel);
                            ManagedPropertyField.this.verticalPanel.layout();
                        }
                    }
                });
            }
        });
        horizontalPanel.add((Widget)removeButton);
        this.sections.add(sectionIndex, section);
        this.verticalPanel.insert((Widget)horizontalPanel, sectionIndex);
        this.verticalPanel.layout();
    }

    private static final class Section {
        private final Map<String, TextField<?>> inputFields;

        Section(Map<String, TextField<?>> inputFields) {
            this.inputFields = inputFields;
        }
    }
}

