/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ActionContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.FormPanelListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IOnSuccessAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ComponentProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.SampleTypeDisplayID;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SpaceModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.SpaceSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ExperimentChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IChosenEntitiesListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.SampleChooserButton;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.SampleChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.file.AttachmentsFileFieldManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ButtonWithConfirmations;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ApplicationInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.AbstractGenericEntityRegistrationForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.PropertiesEditor;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.ParentSamplesArea;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.SamplePropertyEditor;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractGenericSampleRegisterEditForm
extends AbstractGenericEntityRegistrationForm<SampleType, SampleTypePropertyType> {
    public static final String ID_SUFFIX_CONTAINER = "container";
    public static final String ID_SUFFIX_PARENT = "parent";
    public static final String ID_SUFFIX_EXPERIMENT = "experiment";
    protected SampleType sampleType;
    protected AttachmentsFileFieldManager attachmentsManager;
    protected String attachmentsSessionKey;
    protected String simpleId;
    protected ExperimentChooserField.ExperimentChooserFieldAdaptor experimentField;
    private ExperimentIdentifier initialExperimentIdentifierOrNull;
    protected SpaceSelectionWidget groupSelectionWidget;
    private String initialGroupCodeOrNull;
    protected SampleChooserField.SampleChooserFieldAdaptor container;
    protected SampleChooserButton.SampleChooserButtonAdaptor parentButton;
    protected ParentSamplesArea parentsArea;
    private String sampleIdentifierForUploadOrNull = null;
    private Button saveUploadButton;

    protected AbstractGenericSampleRegisterEditForm(IViewContext<IGenericClientServiceAsync> viewContext, Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions, ActionContext actionContext) {
        this(viewContext, inputWidgetDescriptions, actionContext, null);
    }

    protected AbstractGenericSampleRegisterEditForm(IViewContext<IGenericClientServiceAsync> viewContext, Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions, ActionContext actionContext, IIdAndCodeHolder identifiable) {
        super(viewContext, inputWidgetDescriptions, identifiable, EntityKind.SAMPLE);
        boolean cifexConfigured;
        this.simpleId = AbstractGenericSampleRegisterEditForm.createSimpleId(identifiable, EntityKind.SAMPLE);
        this.attachmentsSessionKey = String.valueOf(this.simpleId) + "_attachments";
        ArrayList<String> sesionKeys = new ArrayList<String>();
        sesionKeys.add(this.attachmentsSessionKey);
        this.addUploadFeatures(sesionKeys);
        this.extractInitialValues(actionContext);
        this.saveUploadButton = this.createSaveAndUploadButton();
        ApplicationInfo applicationInfo = viewContext.getModel().getApplicationInfo();
        boolean bl = cifexConfigured = StringUtils.isNotBlank(applicationInfo.getCifexRecipient()) && StringUtils.isNotBlank(applicationInfo.getCifexURL());
        if (cifexConfigured) {
            this.formPanel.addButton(this.saveUploadButton);
        }
    }

    private void extractInitialValues(ActionContext context) {
        this.initialExperimentIdentifierOrNull = this.tryGetExperimentIdentifier(context);
        this.initialGroupCodeOrNull = this.tryGetSpaceCode(context);
    }

    private ExperimentIdentifier tryGetExperimentIdentifier(ActionContext context) {
        return context.tryGetExperiment() == null ? null : ExperimentIdentifier.createIdentifier(context.tryGetExperiment());
    }

    private String tryGetSpaceCode(ActionContext context) {
        return context.tryGetSpaceCode() == null ? null : context.tryGetSpaceCode();
    }

    private ExperimentChooserField.ExperimentChooserFieldAdaptor createExperimentField() {
        String label = this.viewContext.getMessage(ID_SUFFIX_EXPERIMENT, new Object[0]);
        return ExperimentChooserField.create(label, false, this.initialExperimentIdentifierOrNull, this.viewContext.getCommonViewContext());
    }

    @Override
    protected void setUploadEnabled(boolean enabled) {
        super.setUploadEnabled(enabled);
        this.saveUploadButton.setEnabled(enabled);
    }

    private void redefineSaveListeners() {
        this.saveButton.removeAllListeners();
        this.addSaveButtonConfirmationListener();
        this.saveButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                if (AbstractGenericSampleRegisterEditForm.this.formPanel.isValid()) {
                    if (AbstractGenericSampleRegisterEditForm.this.attachmentsManager.filesDefined() > 0) {
                        AbstractGenericSampleRegisterEditForm.this.setUploadEnabled(false);
                        AbstractGenericSampleRegisterEditForm.this.formPanel.submit();
                    } else {
                        AbstractGenericSampleRegisterEditForm.this.save();
                    }
                }
            }
        });
    }

    private Button createSaveAndUploadButton() {
        ButtonWithConfirmations button = new ButtonWithConfirmations();
        button.setText(this.viewContext.getMessage("button_save_and_upload", new Object[0]));
        this.addSaveButtonConfirmationListener(button);
        button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                if (AbstractGenericSampleRegisterEditForm.this.formPanel.isValid()) {
                    AbstractGenericSampleRegisterEditForm.this.sampleIdentifierForUploadOrNull = AbstractGenericSampleRegisterEditForm.this.createSampleIdentifier();
                    if (AbstractGenericSampleRegisterEditForm.this.attachmentsManager.filesDefined() > 0) {
                        AbstractGenericSampleRegisterEditForm.this.setUploadEnabled(false);
                        AbstractGenericSampleRegisterEditForm.this.formPanel.submit();
                    } else {
                        AbstractGenericSampleRegisterEditForm.this.save();
                    }
                }
            }
        });
        return button;
    }

    protected <R, T extends AbstractRegistrationForm.AbstractRegistrationCallback<R>> T enrichWithPostRegistration(T callback) {
        callback.addOnFailureAction(new IDelegatedAction(){

            @Override
            public void execute() {
                AbstractGenericSampleRegisterEditForm.this.sampleIdentifierForUploadOrNull = null;
            }
        });
        callback.addOnSuccessAction(new IOnSuccessAction<R>(){

            @Override
            public void execute(R result) {
                if (!StringUtils.isBlank(AbstractGenericSampleRegisterEditForm.this.sampleIdentifierForUploadOrNull)) {
                    DispatcherHelper.dispatchNaviEvent(new ComponentProvider(AbstractGenericSampleRegisterEditForm.this.viewContext.getCommonViewContext()).getDataSetUploadTab(AbstractGenericSampleRegisterEditForm.this.sampleIdentifierForUploadOrNull));
                }
                AbstractGenericSampleRegisterEditForm.this.sampleIdentifierForUploadOrNull = null;
            }
        });
        return callback;
    }

    protected abstract void save();

    @Override
    public final void submitValidForm() {
    }

    @Override
    protected PropertiesEditor<SampleType, SampleTypePropertyType> createPropertiesEditor(String id, Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions, IViewContext<ICommonClientServiceAsync> context) {
        SamplePropertyEditor editor = new SamplePropertyEditor(id, inputWidgetDescriptions, context);
        return editor;
    }

    @Override
    protected List<DatabaseModificationAwareField<?>> getEntitySpecificFormFields() {
        ArrayList fields = new ArrayList();
        fields.add(DatabaseModificationAwareField.wrapUnaware(this.experimentField.getField()));
        fields.add(this.groupSelectionWidget.asDatabaseModificationAware());
        fields.add(DatabaseModificationAwareField.wrapUnaware(this.parentsArea));
        fields.add(DatabaseModificationAwareField.wrapUnaware(this.parentButton.getField()));
        fields.add(DatabaseModificationAwareField.wrapUnaware(this.container.getField()));
        return fields;
    }

    @Override
    protected void addFormFieldsToPanel(FormPanel panel) {
        super.addFormFieldsToPanel(panel);
        this.attachmentsManager.addAttachmentFieldSetsToPanel(panel);
    }

    @Override
    protected void resetPanel() {
        super.resetPanel();
        this.attachmentsManager.resetAttachmentFieldSetsInPanel(this.formPanel);
    }

    @Override
    protected void revertPanel() {
        super.revertPanel();
        this.attachmentsManager.resetAttachmentFieldSetsInPanel(this.formPanel);
    }

    @Override
    protected String getGeneratedCodePrefix() {
        return this.sampleType.getGeneratedCodePrefix();
    }

    @Override
    protected void createEntitySpecificFormFields() {
        this.groupSelectionWidget = new SpaceSelectionWidget(this.viewContext, this.getId(), true, false, this.initialGroupCodeOrNull);
        this.groupSelectionWidget.setId("register-sample-space-selection");
        FieldUtil.markAsMandatory(this.groupSelectionWidget);
        this.groupSelectionWidget.setFieldLabel(this.viewContext.getMessage("group", new Object[0]));
        this.parentButton = SampleChooserButton.create(null, this.viewContext.getMessage("add_parent", new Object[0]), true, false, false, this.viewContext.getCommonViewContext(), String.valueOf(this.getId()) + ID_SUFFIX_PARENT, SampleTypeDisplayID.SAMPLE_REGISTRATION_PARENT_CHOOSER.withSuffix(this.getSampleTypeCode()), true);
        this.parentsArea = new ParentSamplesArea(this.viewContext, this.getId());
        SampleChooserButton parentChooserButton = this.parentButton.getChooserButton();
        parentChooserButton.addChosenEntityListener(new IChosenEntitiesListener<TableModelRowWithObject<Sample>>(){

            @Override
            public void entitiesChosen(List<TableModelRowWithObject<Sample>> entities) {
                for (TableModelRowWithObject<Sample> row : entities) {
                    AbstractGenericSampleRegisterEditForm.this.parentsArea.appendItem(row.getObjectOrNull().getIdentifier());
                }
            }
        });
        this.container = SampleChooserField.create(this.viewContext.getMessage("part_of_sample", new Object[0]), false, null, true, false, false, this.viewContext.getCommonViewContext(), String.valueOf(this.getId()) + ID_SUFFIX_CONTAINER, SampleTypeDisplayID.SAMPLE_REGISTRATION_CONTAINER_CHOOSER.withSuffix(this.getSampleTypeCode()), false);
        this.experimentField = this.createExperimentField();
        this.experimentField.getChooserField().setId(String.valueOf(this.getId()) + ID_SUFFIX_EXPERIMENT);
        this.experimentField.getChooserField().addChosenEntityListener(new IChosenEntitiesListener<TableModelRowWithObject<Experiment>>(){

            @Override
            public void entitiesChosen(List<TableModelRowWithObject<Experiment>> entities) {
                if (!entities.isEmpty()) {
                    AbstractGenericSampleRegisterEditForm.this.groupSelectionWidget.setValue((ModelData)new SpaceModel(entities.get(0).getObjectOrNull().getProject().getSpace()));
                }
            }
        });
        this.attachmentsManager = new AttachmentsFileFieldManager(this.attachmentsSessionKey, this.viewContext);
        this.formPanel.addListener(Events.Submit, new FormPanelListener(this.infoBox){

            @Override
            protected void onSuccessfullUpload() {
                AbstractGenericSampleRegisterEditForm.this.save();
            }

            @Override
            protected void setUploadEnabled() {
                AbstractGenericSampleRegisterEditForm.this.setUploadEnabled(true);
            }
        });
        this.redefineSaveListeners();
        this.setContainerAndParentVisibility(this.sampleType);
    }

    protected final String createSampleIdentifier() {
        return AbstractGenericSampleRegisterEditForm.createSampleIdentifier(this.groupSelectionWidget, (Field<String>)this.codeField);
    }

    public static final String createSampleIdentifier(SpaceSelectionWidget spaceSelectionWidget, Field<String> codeField) {
        Space space = spaceSelectionWidget.tryGetSelectedSpace();
        boolean shared = SpaceSelectionWidget.isSharedSpace(space);
        String code = (String)codeField.getValue();
        StringBuilder builder = new StringBuilder("/");
        if (!shared) {
            builder.append(String.valueOf(space.getCode()) + "/");
        }
        builder.append(code);
        return builder.toString().toUpperCase();
    }

    private final void setContainerAndParentVisibility(SampleType sampleType) {
        boolean showContainer = sampleType.isShowContainer();
        boolean showParents = sampleType.isShowParents();
        FieldUtil.setVisibility(showContainer, this.container.getField());
        FieldUtil.setVisibility(showParents, new Field[]{this.parentButton.getField(), this.parentsArea});
    }

    private String getSampleTypeCode() {
        return this.sampleType.getCode();
    }

    protected String[] getParents() {
        return this.parentsArea.tryGetSamples();
    }
}

