/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.FormPanelListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.file.BasicFileFieldManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FormEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.form.FileUploadField;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;

public abstract class AbstractSampleBatchRegistrationForm
extends AbstractRegistrationForm {
    private static final String FIELD_LABEL_TEMPLATE = "File";
    private static final int DEFAULT_NUMBER_OF_FILES = 1;
    private final BasicFileFieldManager fileFieldsManager;
    private final String sessionKey;

    public AbstractSampleBatchRegistrationForm(IMessageProvider messageProvider, String sessionKey) {
        super(messageProvider, AbstractSampleBatchRegistrationForm.createId(sessionKey));
        this.sessionKey = sessionKey;
        this.fileFieldsManager = new BasicFileFieldManager(sessionKey, 1, FIELD_LABEL_TEMPLATE);
        this.fileFieldsManager.setMandatory();
        this.setScrollMode(Style.Scroll.AUTO);
        this.addUploadFeatures(sessionKey);
    }

    protected abstract void save();

    protected abstract void addSpecificFormFields(FormPanel var1);

    protected String getSessionKey() {
        return this.sessionKey;
    }

    @Override
    protected final void submitValidForm() {
    }

    protected final void onRender(Element target, int index) {
        super.onRender(target, index);
        this.addFormFields();
    }

    @Override
    protected void resetFieldsAfterSave() {
        for (FileUploadField attachmentField : this.fileFieldsManager.getFields()) {
            attachmentField.reset();
        }
        this.updateDirtyCheckAfterSave();
    }

    private static String createId(String sessionKey) {
        return "openbis_" + sessionKey;
    }

    private final void addFormFields() {
        this.addSpecificFormFields(this.formPanel);
        for (FileUploadField attachmentField : this.fileFieldsManager.getFields()) {
            this.formPanel.add((Widget)DatabaseModificationAwareField.wrapUnaware(attachmentField).get());
        }
        this.formPanel.addListener(Events.BeforeSubmit, (Listener)new Listener<FormEvent>(){

            public void handleEvent(FormEvent be) {
                AbstractSampleBatchRegistrationForm.this.infoBox.displayProgress(AbstractSampleBatchRegistrationForm.this.messageProvider.getMessage("progress_uploading", new Object[0]));
            }
        });
        this.formPanel.addListener(Events.Submit, new FormPanelListener(this.infoBox){

            @Override
            protected void onSuccessfullUpload() {
                AbstractSampleBatchRegistrationForm.this.infoBox.displayProgress(AbstractSampleBatchRegistrationForm.this.messageProvider.getMessage("progress_processing", new Object[0]));
                AbstractSampleBatchRegistrationForm.this.save();
            }

            @Override
            protected void setUploadEnabled() {
                AbstractSampleBatchRegistrationForm.this.setUploadEnabled(true);
            }
        });
        this.redefineSaveListeners();
    }

    private void redefineSaveListeners() {
        this.saveButton.removeAllListeners();
        this.addSaveButtonConfirmationListener();
        this.saveButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                if (AbstractSampleBatchRegistrationForm.this.formPanel.isValid()) {
                    if (AbstractSampleBatchRegistrationForm.this.fileFieldsManager.filesDefined() > 0) {
                        AbstractSampleBatchRegistrationForm.this.setUploadEnabled(false);
                        AbstractSampleBatchRegistrationForm.this.formPanel.submit();
                    } else {
                        AbstractSampleBatchRegistrationForm.this.save();
                    }
                }
            }
        });
    }

    @Override
    protected void setUploadEnabled(boolean enabled) {
        super.setUploadEnabled(enabled);
        this.infoBoxResetListener.setEnabled(enabled);
    }
}

