/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientService;
import ch.systemsx.cisd.openbis.generic.client.web.server.AbstractFileDownloadServlet;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentWithContent;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.plugin.generic.shared.IGenericServer;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/attachment-download", "/openbis/attachment-download"})
public class AttachmentDownloadServlet
extends AbstractFileDownloadServlet {
    @Resource(name="generic-plugin-server")
    private IGenericServer server;
    @Resource(name="common-service")
    private ICommonClientService commonService;

    public AttachmentDownloadServlet() {
        this.setRequireSession(false);
    }

    @Private
    public AttachmentDownloadServlet(IGenericServer server) {
        this.server = server;
    }

    @Override
    protected AbstractFileDownloadServlet.FileContent getFileContent(HttpServletRequest request) throws Exception {
        String versionStringOrNull = request.getParameter("version");
        Integer versionOrNull = null;
        if (versionStringOrNull != null) {
            versionOrNull = Integer.parseInt(versionStringOrNull);
        }
        String fileName = StringEscapeUtils.unescapeHtml((String)request.getParameter("fileName"));
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        String techIdString = request.getParameter("id");
        String attachmentHolderKind = request.getParameter("attachmentHolder");
        TechId techId = null;
        if (StringUtils.isNotBlank((String)techIdString)) {
            techId = new TechId(Long.parseLong(techIdString));
        } else {
            String permId = request.getParameter("permId");
            if (StringUtils.isNotBlank((String)permId)) {
                techId = new TechId(this.getTechId(attachmentHolderKind, permId));
            }
        }
        if (StringUtils.isNotBlank((String)fileName) && techId != null && StringUtils.isNotBlank((String)attachmentHolderKind)) {
            if (attachmentHolderKind.equals(AttachmentHolderKind.EXPERIMENT.name())) {
                return this.getExperimentFile(request, versionOrNull, fileName, techId);
            }
            if (attachmentHolderKind.equals(AttachmentHolderKind.SAMPLE.name())) {
                return this.getSampleFile(request, versionOrNull, fileName, techId);
            }
            if (attachmentHolderKind.equals(AttachmentHolderKind.PROJECT.name())) {
                return this.getProjectFile(request, versionOrNull, fileName, techId);
            }
        }
        return null;
    }

    private Long getTechId(String attachmentHolderKind, String permId) {
        if (attachmentHolderKind.equals(AttachmentHolderKind.EXPERIMENT.name())) {
            return this.commonService.getEntityInformationHolder(EntityKind.EXPERIMENT, permId).getId();
        }
        if (attachmentHolderKind.equals(AttachmentHolderKind.SAMPLE.name())) {
            return this.commonService.getProjectInfoByPermId(permId).getId();
        }
        if (attachmentHolderKind.equals(AttachmentHolderKind.PROJECT.name())) {
            return this.commonService.getEntityInformationHolder(EntityKind.SAMPLE, permId).getId();
        }
        return null;
    }

    private AbstractFileDownloadServlet.FileContent getExperimentFile(HttpServletRequest request, Integer versionOrNull, String fileName, TechId experimentId) {
        AttachmentWithContent attachment = this.server.getExperimentFileAttachment(this.getSessionToken(request), experimentId, fileName, versionOrNull);
        return new AbstractFileDownloadServlet.FileContent(attachment.getContent(), attachment.getFileName());
    }

    private AbstractFileDownloadServlet.FileContent getSampleFile(HttpServletRequest request, Integer versionOrNull, String fileName, TechId sampleId) {
        AttachmentWithContent attachment = this.server.getSampleFileAttachment(this.getSessionToken(request), sampleId, fileName, versionOrNull);
        return new AbstractFileDownloadServlet.FileContent(attachment.getContent(), attachment.getFileName());
    }

    private AbstractFileDownloadServlet.FileContent getProjectFile(HttpServletRequest request, Integer versionOrNull, String fileName, TechId projectId) {
        AttachmentWithContent attachment = this.server.getProjectFileAttachment(this.getSessionToken(request), projectId, fileName, versionOrNull);
        return new AbstractFileDownloadServlet.FileContent(attachment.getContent(), attachment.getFileName());
    }
}

