/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.server;

import ch.systemsx.cisd.common.io.DelegatedReader;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchRegistrationResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewBasicExperiment;
import ch.systemsx.cisd.openbis.generic.shared.parser.BisTabFileLoader;
import ch.systemsx.cisd.openbis.generic.shared.parser.NamedInputStream;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.server.parser.NewBasicExperimentParserObjectFactory;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ExperimentLoader {
    private List<BatchRegistrationResult> results;
    private List<NewBasicExperiment> newExperiments;
    private BisTabFileLoader<NewBasicExperiment> tabFileLoader;

    public void load(Collection<NamedInputStream> files) {
        this.tabFileLoader = new BisTabFileLoader<NewBasicExperiment>(new IParserObjectFactoryFactory<NewBasicExperiment>(){

            @Override
            public final IParserObjectFactory<NewBasicExperiment> createFactory(IPropertyMapper propertyMapper) throws ParserException {
                return new NewBasicExperimentParserObjectFactory(propertyMapper);
            }
        }, false);
        this.newExperiments = new ArrayList<NewBasicExperiment>();
        this.results = new ArrayList<BatchRegistrationResult>(files.size());
        for (NamedInputStream file : files) {
            Reader reader = file.getUnicodeReader();
            Map<String, String> defaults = Collections.emptyMap();
            List<NewBasicExperiment> loadedExperiments = this.tabFileLoader.load(new DelegatedReader(reader, file.getOriginalFilename()), defaults);
            this.newExperiments.addAll(loadedExperiments);
            this.results.add(new BatchRegistrationResult(file.getOriginalFilename(), String.format("%d experiment(s) found and registered.", loadedExperiments.size())));
        }
    }

    public List<BatchRegistrationResult> getResults() {
        return new ArrayList<BatchRegistrationResult>(this.results);
    }

    public List<NewBasicExperiment> getNewBasicExperiments() {
        return new ArrayList<NewBasicExperiment>(this.newExperiments);
    }
}

