/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.server.parser;

import ch.systemsx.cisd.common.parser.AbstractParserObjectFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.IPropertyModel;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetBatchUpdateDetails;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.UpdatedDataSet;
import java.util.ArrayList;
import java.util.HashSet;

public final class UpdatedDataSetParserObjectFactory
extends AbstractParserObjectFactory<NewDataSet> {
    private final DataSetBatchUpdateDetails basicBatchUpdateDetails = this.createBasicBatchUpdateDetails();

    public UpdatedDataSetParserObjectFactory(IPropertyMapper propertyMapper) {
        super(NewDataSet.class, propertyMapper);
    }

    @Override
    public final NewDataSet createObject(String[] lineTokens) throws ParserException {
        NewDataSet newDataSet = (NewDataSet)super.createObject(lineTokens);
        this.setProperties(newDataSet, lineTokens);
        DataSetBatchUpdateDetails updateDetails = this.createBatchUpdateDetails(newDataSet);
        this.cleanUp(newDataSet);
        return new UpdatedDataSet(newDataSet, updateDetails);
    }

    private final void setProperties(NewDataSet newObject, String[] lineTokens) {
        ArrayList<EntityProperty> properties = new ArrayList<EntityProperty>();
        for (String unmatchedProperty : this.getUnmatchedProperties()) {
            String propertyDefault;
            IPropertyModel propertyModel = this.tryGetPropertyModel(unmatchedProperty);
            String propertyValue = this.getPropertyValue(lineTokens, propertyModel, propertyDefault = this.tryGetPropertyDefault(unmatchedProperty));
            if (!UpdatedDataSetParserObjectFactory.isNotEmpty(propertyValue)) continue;
            EntityProperty property = new EntityProperty();
            property.setPropertyType(this.createPropertyType(unmatchedProperty));
            property.setValue(propertyValue);
            properties.add(property);
        }
        newObject.setProperties(properties.toArray(IEntityProperty.EMPTY_ARRAY));
    }

    private final PropertyType createPropertyType(String propertyTypeCode) {
        PropertyType propertyType = new PropertyType();
        propertyType.setCode(propertyTypeCode);
        return propertyType;
    }

    private DataSetBatchUpdateDetails createBasicBatchUpdateDetails() {
        DataSetBatchUpdateDetails details = new DataSetBatchUpdateDetails();
        details.setExperimentUpdateRequested(this.isColumnAvailable("experiment"));
        details.setSampleUpdateRequested(this.isColumnAvailable("sample"));
        details.setParentsUpdateRequested(this.isColumnAvailable("parents"));
        details.setContainerUpdateRequested(this.isColumnAvailable("container"));
        details.setFileFormatUpdateRequested(this.isColumnAvailable("file_format"));
        return details;
    }

    private DataSetBatchUpdateDetails createBatchUpdateDetails(NewDataSet dataSet) {
        DataSetBatchUpdateDetails details = new DataSetBatchUpdateDetails();
        details.setExperimentUpdateRequested(this.basicBatchUpdateDetails.isExperimentUpdateRequested() && UpdatedDataSetParserObjectFactory.isNotEmpty(dataSet.getExperimentIdentifier()));
        details.setSampleUpdateRequested(this.basicBatchUpdateDetails.isSampleUpdateRequested() && UpdatedDataSetParserObjectFactory.isNotEmpty(dataSet.getSampleIdentifierOrNull()));
        details.setParentsUpdateRequested(this.basicBatchUpdateDetails.isParentsUpdateRequested() && UpdatedDataSetParserObjectFactory.isNotEmpty(dataSet.getParentsIdentifiersOrNull()));
        details.setContainerUpdateRequested(this.basicBatchUpdateDetails.isContainerUpdateRequested() && UpdatedDataSetParserObjectFactory.isNotEmpty(dataSet.getContainerIdentifierOrNull()));
        details.setFileFormatUpdateRequested(this.basicBatchUpdateDetails.isFileFormatUpdateRequested() && UpdatedDataSetParserObjectFactory.isNotEmpty(dataSet.getFileFormatOrNull()));
        HashSet<String> propertiesToUpdate = new HashSet<String>();
        IEntityProperty[] iEntityPropertyArray = dataSet.getProperties();
        int n = iEntityPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEntityProperty property = iEntityPropertyArray[n2];
            propertiesToUpdate.add(property.getPropertyType().getCode());
            ++n2;
        }
        details.setPropertiesToUpdate(propertiesToUpdate);
        return details;
    }

    private void cleanUp(NewDataSet newDataSet) {
        if (UpdatedDataSetParserObjectFactory.isDeletionMark(newDataSet.getExperimentIdentifier())) {
            throw new ParserException("experiment column is required and cannot be marked for deletetion.");
        }
        if (UpdatedDataSetParserObjectFactory.isEmpty(newDataSet.getExperimentIdentifier())) {
            newDataSet.setExperimentIdentifier(null);
        }
        if (UpdatedDataSetParserObjectFactory.isDeletionMark(newDataSet.getSampleIdentifierOrNull()) || UpdatedDataSetParserObjectFactory.isEmpty(newDataSet.getSampleIdentifierOrNull())) {
            newDataSet.setSampleIdentifierOrNull(null);
        }
        if (UpdatedDataSetParserObjectFactory.isDeletionMark(newDataSet.getParentsIdentifiersOrNull()) || UpdatedDataSetParserObjectFactory.isEmpty(newDataSet.getParentsIdentifiersOrNull())) {
            newDataSet.setParentsIdentifiersOrNull((String)null);
        }
        if (UpdatedDataSetParserObjectFactory.isDeletionMark(newDataSet.getContainerIdentifierOrNull()) || UpdatedDataSetParserObjectFactory.isEmpty(newDataSet.getContainerIdentifierOrNull())) {
            newDataSet.setContainerIdentifierOrNull(null);
        }
        if (UpdatedDataSetParserObjectFactory.isDeletionMark(newDataSet.getFileFormatOrNull()) || UpdatedDataSetParserObjectFactory.isEmpty(newDataSet.getFileFormatOrNull())) {
            newDataSet.setFileFormatOrNull(null);
        }
        ArrayList<IEntityProperty> updatedProperties = new ArrayList<IEntityProperty>();
        IEntityProperty[] iEntityPropertyArray = newDataSet.getProperties();
        int n = iEntityPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEntityProperty property = iEntityPropertyArray[n2];
            if (!UpdatedDataSetParserObjectFactory.isDeletionMark(property.getValue())) {
                updatedProperties.add(property);
            }
            ++n2;
        }
        newDataSet.setProperties(updatedProperties.toArray(IEntityProperty.EMPTY_ARRAY));
    }

    @Override
    protected final boolean ignoreUnmatchedProperties() {
        return true;
    }
}

