/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.server;

import ch.systemsx.cisd.openbis.generic.server.batch.BatchOperationExecutor;
import ch.systemsx.cisd.openbis.generic.server.batch.DataSetBatchUpdate;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataSetTable;
import ch.systemsx.cisd.openbis.generic.server.plugin.IDataSetTypeSlaveServerPlugin;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetBatchUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.plugin.generic.server.IGenericBusinessObjectFactory;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="generic-data-set-type-slave-server-plugin")
public class GenericDataSetTypeSlaveServerPlugin
implements IDataSetTypeSlaveServerPlugin {
    @Resource(name="generic-business-object-factory")
    private IGenericBusinessObjectFactory businessObjectFactory;

    @Override
    public void permanentlyDeleteDataSets(Session session, List<DataPE> dataSets, String reason, boolean forceDisallowedTypes) {
        IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(session);
        dataSetTable.setDataSets(dataSets);
        dataSetTable.deleteLoadedDataSets(reason, forceDisallowedTypes);
    }

    @Override
    public void updateDataSets(Session session, List<DataSetBatchUpdatesDTO> dataSets) {
        assert (session != null) : "Unspecified session.";
        assert (dataSets != null && dataSets.size() > 0) : "Unspecified data set or empty data sets.";
        BatchOperationExecutor.executeInBatches(new DataSetBatchUpdate(this.businessObjectFactory.createDataSetTable(session), dataSets));
    }
}

