/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.server;

import ch.systemsx.cisd.authentication.ISessionManager;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.shared.AbstractServerLogger;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentWithContent;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewDataSetsWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperimentsWithType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterialsWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSamplesWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleParentWithDerived;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.UpdatedExperimentsWithType;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.plugin.generic.shared.IGenericServer;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

final class GenericServerLogger
extends AbstractServerLogger
implements IGenericServer {
    GenericServerLogger(ISessionManager<Session> sessionManager, IInvocationLoggerContext context) {
        super(sessionManager, context);
    }

    public final SampleParentWithDerived getSampleInfo(String sessionToken, SampleIdentifier identifier) {
        this.logAccess(sessionToken, "get_sample_info", "IDENTIFIER(%s)", identifier);
        return null;
    }

    @Override
    public final SampleParentWithDerived getSampleInfo(String sessionToken, TechId sampleId) {
        this.logAccess(sessionToken, "get_sample_info", "ID(%s)", sampleId);
        return null;
    }

    @Override
    public void registerSample(String sessionToken, NewSample newSample, Collection<NewAttachment> attachments) {
        this.logTracking(sessionToken, "register_sample", "SAMPLE_TYPE(%s) SAMPLE(%S) ATTACHMENTS(%S)", newSample.getSampleType(), newSample.getIdentifier(), attachments.size());
    }

    @Override
    public AbstractExternalData getDataSetInfo(String sessionToken, TechId datasetId) {
        this.logAccess(sessionToken, "get_data_set_info", "ID(%s)", datasetId);
        return null;
    }

    @Override
    public void registerExperiment(String sessionToken, NewExperiment experiment, Collection<NewAttachment> attachments) {
        this.logTracking(sessionToken, "register_experiment", "EXPERIMENT_TYPE(%s) EXPERIMENT(%S) ATTACHMENTS(%S)", experiment.getExperimentTypeCode(), experiment.getIdentifier(), attachments.size());
    }

    @Override
    public void registerMaterials(String sessionToken, List<NewMaterialsWithTypes> newMaterials) {
        this.logTracking(sessionToken, "register_materials", GenericServerLogger.getMaterials(newMaterials), new Object[0]);
    }

    @Override
    public int updateMaterials(String sessionToken, List<NewMaterialsWithTypes> newMaterials, boolean ignoreUnregisteredMaterials) throws UserFailureException {
        this.logTracking(sessionToken, "update_materials", "MATERIALS(%S) IGNORE_UNREGISTERED_MATERIALS(%S)", GenericServerLogger.getMaterials(newMaterials), ignoreUnregisteredMaterials);
        return 0;
    }

    @Override
    public void updateMaterialsAsync(String sessionToken, List<NewMaterialsWithTypes> newMaterials, boolean ignoreUnregisteredMaterials, String userEmail) throws UserFailureException {
        this.logTracking(sessionToken, "update_materials_async", "MATERIALS(%S) IGNORE_UNREGISTERED_MATERIALS(%S) USER_EMAIL(%S)", GenericServerLogger.getMaterials(newMaterials), ignoreUnregisteredMaterials, userEmail);
    }

    @Override
    public AttachmentWithContent getExperimentFileAttachment(String sessionToken, TechId experimentId, String filename, Integer versionOrNull) throws UserFailureException {
        this.logAccess(sessionToken, "get_attachment", "EXPERIMENT_ID(%s) FILE(%s) VERSION(%s)", experimentId, filename, versionOrNull);
        return null;
    }

    @Override
    public AttachmentWithContent getProjectFileAttachment(String sessionToken, TechId projectId, String fileName, Integer versionOrNull) {
        this.logAccess(sessionToken, "get_attachment", "PROJECT_ID(%s) FILE(%s) VERSION(%s)", projectId, fileName, versionOrNull);
        return null;
    }

    @Override
    public AttachmentWithContent getSampleFileAttachment(String sessionToken, TechId sampleId, String fileName, Integer versionOrNull) {
        this.logAccess(sessionToken, "get_attachment", "SAMPLE_ID(%s) FILE(%s) VERSION(%s)", sampleId, fileName, versionOrNull);
        return null;
    }

    @Override
    public List<String> generateCodes(String sessionToken, String prefix, EntityKind entityKind, int number) {
        this.logAccess(sessionToken, "generate_codes", "PREFIX(%s) ENTITY_KIND(%s) NUMBER(%s)", prefix, entityKind, number);
        return null;
    }

    @Override
    public ExperimentUpdateResult updateExperiment(String sessionToken, ExperimentUpdatesDTO updates) {
        this.logTracking(sessionToken, "edit_experiment", "EXPERIMENT(%s) ATTACHMENTS_ADDED(%s) NEW_PROJECT(%s) SAMPLES(%s)", updates.getExperimentId(), updates.getAttachments().size(), updates.getProjectIdentifier(), StringUtils.join((Object[])updates.getSampleCodes(), (String)","));
        return null;
    }

    @Override
    public Date updateMaterial(String sessionToken, TechId materialId, List<IEntityProperty> properties, String[] metaprojects, Date version) {
        this.logTracking(sessionToken, "edit_material", "MATERIAL(%s)", materialId);
        return null;
    }

    @Override
    public SampleUpdateResult updateSample(String sessionToken, SampleUpdatesDTO updates) {
        this.logTracking(sessionToken, "edit_sample", "SAMPLE(%s), CHANGE_TO_EXPERIMENT(%s) ATTACHMENTS(%s)", updates.getSampleIdOrNull(), updates.getExperimentIdentifierOrNull(), updates.getAttachments().size());
        return null;
    }

    @Override
    public DataSetUpdateResult updateDataSet(String sessionToken, DataSetUpdatesDTO updates) {
        this.logTracking(sessionToken, "edit_data_set", "DATA_SET(%s) SAMPLE(%s) MODIFIED_PARENTS(%s)", updates.getDatasetId(), updates.getSampleIdentifierOrNull(), StringUtils.join((Object[])updates.getModifiedParentDatasetCodesOrNull(), (String)","));
        return null;
    }

    @Override
    public void registerSamples(String sessionToken, List<NewSamplesWithTypes> newSamplesWithType) throws UserFailureException {
        this.logTracking(sessionToken, "register_samples", GenericServerLogger.getSamples(newSamplesWithType), new Object[0]);
    }

    @Override
    public void updateSamples(String sessionToken, List<NewSamplesWithTypes> updatedSamplesWithType) throws UserFailureException {
        this.logTracking(sessionToken, "update_samples", GenericServerLogger.getSamples(updatedSamplesWithType), new Object[0]);
    }

    @Override
    public void registerOrUpdateMaterials(String sessionToken, List<NewMaterialsWithTypes> materials) {
        for (NewMaterialsWithTypes materialsWithType : materials) {
            this.logTracking(sessionToken, "registerOrUpdateMaterials", "type(%s) numberOfMaterials(%s)", ((MaterialType)materialsWithType.getEntityType()).getCode(), materialsWithType.getNewEntities().size());
        }
    }

    @Override
    public void registerOrUpdateMaterialsAsync(String sessionToken, List<NewMaterialsWithTypes> materials, String userEmail) {
        for (NewMaterialsWithTypes materialsWithType : materials) {
            this.logTracking(sessionToken, "registerOrUpdateMaterialsAsync", "type(%s) numberOfMaterials(%s) userEmail(%s)", ((MaterialType)materialsWithType.getEntityType()).getCode(), materialsWithType.getNewEntities().size(), userEmail);
        }
    }

    @Override
    public void registerOrUpdateSamples(String sessionToken, List<NewSamplesWithTypes> newSamplesWithType) throws UserFailureException {
        this.logTracking(sessionToken, "register_or_update_samples", GenericServerLogger.getSamples(newSamplesWithType), new Object[0]);
    }

    @Override
    public void updateDataSets(String sessionToken, NewDataSetsWithTypes dataSets) throws UserFailureException {
        this.logTracking(sessionToken, "update_data_sets", String.valueOf(dataSets.getDataSetType().getCode()) + ":" + dataSets.getNewDataSets().size(), new Object[0]);
    }

    @Override
    public void registerExperiments(String sessionToken, NewExperimentsWithType experiments) throws UserFailureException {
        this.logTracking(sessionToken, "register_experiments", "TYPE(%s) EXPERIMENTS(%s)", experiments.getExperimentTypeCode(), experiments.getNewExperiments().size());
    }

    @Override
    public void updateExperiments(String sessionToken, UpdatedExperimentsWithType experiments) throws UserFailureException {
        this.logTracking(sessionToken, "update_experiments", "TYPE(%s) EXPERIMENTS(%s)", experiments.getExperimentType().getCode(), experiments.getUpdatedExperiments().size());
    }

    @Override
    public void registerOrUpdateSamplesAndMaterials(String sessionToken, List<NewSamplesWithTypes> newSamplesWithType, List<NewMaterialsWithTypes> newMaterialsWithType) throws UserFailureException {
        this.logTracking(sessionToken, "register_or_update_samples_and_materials", "SAMPLES(%s) MATERIALS(%s)", GenericServerLogger.getSamples(newSamplesWithType), GenericServerLogger.getMaterials(newMaterialsWithType));
    }

    @Override
    public void registerOrUpdateSamplesAndMaterialsAsync(String sessionToken, List<NewSamplesWithTypes> newSamplesWithType, List<NewMaterialsWithTypes> newMaterialsWithType, String userEmail) throws UserFailureException {
        this.logTracking(sessionToken, "register_or_update_samples_and_materials_async", "SAMPLES(%s) MATERIALS(%s) EMAIL(%s)", GenericServerLogger.getSamples(newSamplesWithType), GenericServerLogger.getMaterials(newMaterialsWithType), userEmail);
    }

    @Override
    public void registerOrUpdateSamplesAsync(String sessionToken, List<NewSamplesWithTypes> newSamplesWithType, String userEmail) throws UserFailureException {
        this.logTracking(sessionToken, "register_or_update_samples_async", "SAMPLES(%s) EMAIL(%s)", GenericServerLogger.getSamples(newSamplesWithType), userEmail);
    }

    private static String getSamples(List<NewSamplesWithTypes> newSamplesWithType) {
        StringBuilder samples = new StringBuilder();
        for (NewSamplesWithTypes s : newSamplesWithType) {
            if (samples.length() > 0) {
                samples.append(",");
            }
            samples.append(String.valueOf(((SampleType)s.getEntityType()).getCode()) + ":" + s.getNewEntities().size());
        }
        return samples.toString();
    }

    private static String getMaterials(List<NewMaterialsWithTypes> newMaterialsWithType) {
        StringBuilder materials = new StringBuilder();
        for (NewMaterialsWithTypes s : newMaterialsWithType) {
            if (materials.length() > 0) {
                materials.append(",");
            }
            materials.append(String.valueOf(((MaterialType)s.getEntityType()).getCode()) + ":" + s.getNewEntities().size());
        }
        return materials.toString();
    }
}

