/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.client.api.v1;

import ch.systemsx.cisd.common.api.retry.RetryCaller;
import ch.systemsx.cisd.common.api.retry.RetryProxyFactory;
import ch.systemsx.cisd.openbis.common.api.client.ServiceFinder;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import ch.systemsx.cisd.openbis.plugin.query.client.api.v1.IQueryApiFacade;
import ch.systemsx.cisd.openbis.plugin.query.client.api.v1.QueryApiFacade;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.IQueryApiServer;

public class FacadeFactory {
    private static final ServiceFinder QUERY_SERVICE_FINDER = new ServiceFinder("openbis", "/rmi-query-v1");
    private static final ServiceFinder GENERAL_INFORMATION_SERVICE_FINDER = new ServiceFinder("openbis", "/rmi-general-information-v1");

    public static IQueryApiFacade create(final String serverURL, final String userID, final String password) {
        RetryCaller<IQueryApiFacade, RuntimeException> caller = new RetryCaller<IQueryApiFacade, RuntimeException>(){

            @Override
            protected IQueryApiFacade call() {
                IQueryApiServer service = FacadeFactory.createQueryService(serverURL);
                String sessionToken = service.tryToAuthenticateAtQueryServer(userID, password);
                if (sessionToken == null) {
                    throw new IllegalArgumentException("User " + userID + " couldn't be authenticated");
                }
                QueryApiFacade facade = new QueryApiFacade(service, FacadeFactory.createGeneralInfoService(serverURL), sessionToken);
                return RetryProxyFactory.createProxy(facade);
            }
        };
        return (IQueryApiFacade)caller.callWithRetry();
    }

    public static IQueryApiFacade create(final String serverURL, final String sessionToken) {
        RetryCaller<IQueryApiFacade, RuntimeException> caller = new RetryCaller<IQueryApiFacade, RuntimeException>(){

            @Override
            protected IQueryApiFacade call() {
                QueryApiFacade facade = new QueryApiFacade(FacadeFactory.createQueryService(serverURL), FacadeFactory.createGeneralInfoService(serverURL), sessionToken);
                return RetryProxyFactory.createProxy(facade);
            }
        };
        return (IQueryApiFacade)caller.callWithRetry();
    }

    private static IQueryApiServer createQueryService(String serverURL) {
        return QUERY_SERVICE_FINDER.createService(IQueryApiServer.class, serverURL);
    }

    private static IGeneralInformationService createGeneralInfoService(String serverURL) {
        return GENERAL_INFORMATION_SERVICE_FINDER.createService(IGeneralInformationService.class, serverURL);
    }
}

