/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.DisposableTabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IModule;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.IQueryClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.QuerySectionPanel;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.module.QueryModuleDatabaseMenuItem;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class QueryModule
implements IModule {
    public static final String ID = "openbis_";
    private final IViewContext<IQueryClientServiceAsync> viewContext;
    private int databases;

    QueryModule(IViewContext<IQueryClientServiceAsync> viewContext) {
        this.viewContext = viewContext;
    }

    @Override
    public String getName() {
        return this.viewContext.getMessage("query_module_menu_title", new Object[0]);
    }

    @Override
    public void initialize(AsyncCallback<Void> callback) {
        this.viewContext.getService().initDatabases(new DatabasesInitializationCallback(this.viewContext, callback));
    }

    @Override
    public List<? extends MenuItem> getMenuItems() {
        if (this.databases == 0) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new QueryModuleDatabaseMenuItem(this.viewContext));
    }

    public Collection<? extends DisposableTabContent> getSections(IEntityInformationHolderWithIdentifier entity) {
        if (this.databases == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(new QuerySectionPanel(this.viewContext, entity));
    }

    private final class DatabasesInitializationCallback
    extends AbstractAsyncCallback<Integer> {
        private final AsyncCallback<Void> delegate;

        public DatabasesInitializationCallback(IViewContext<?> viewContext, AsyncCallback<Void> delegate) {
            super(viewContext);
            this.delegate = delegate;
        }

        @Override
        protected void process(Integer result) {
            this.viewContext.log(" query database(s) configured:" + result);
            QueryModule.this.databases = result;
            this.delegate.onSuccess(null);
        }

        @Override
        public void finishOnFailure(Throwable caught) {
            this.delegate.onFailure(caught);
        }
    }
}

