/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.DisposableTabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.QueryType;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.IQueryClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.QueryParameterValue;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.module.QueryViewer;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.module.RunCannedQueryToolbar;
import com.extjs.gxt.ui.client.widget.Component;
import java.util.HashMap;
import java.util.Set;

final class QuerySectionPanel
extends DisposableTabContent {
    private static final String PARAMETER_PREFIX = "_";
    private static final String TYPE = "type";
    private static final String KEY = "key";
    private final IViewContext<IQueryClientServiceAsync> queryModuleContext;
    private final IEntityInformationHolderWithPermId entity;

    public QuerySectionPanel(IViewContext<IQueryClientServiceAsync> queryModuleContext, IEntityInformationHolderWithPermId entity) {
        super(queryModuleContext.getMessage("query_module_menu_title", new Object[0]), queryModuleContext, entity);
        this.queryModuleContext = queryModuleContext;
        this.entity = entity;
        this.setIds(DisplayTypeIDGenerator.QUERY_SECTION);
    }

    @Override
    protected IDisposableComponent createDisposableContent() {
        HashMap<String, QueryParameterValue> parameters = QuerySectionPanel.extractFixedQueryParameters(this.entity);
        RunCannedQueryToolbar toolbar = RunCannedQueryToolbar.createTyped(this.queryModuleContext, null, parameters, QuerySectionPanel.translate(this.entity.getEntityKind()), this.entity.getEntityType());
        final DatabaseModificationAwareComponent viewer = QueryViewer.create(this.queryModuleContext, toolbar);
        return new IDisposableComponent(){

            @Override
            public void dispose() {
                IDatabaseModificationObserver mobserver = viewer.getModificationObserver();
                if (mobserver instanceof IDisposableComponent) {
                    ((IDisposableComponent)mobserver).dispose();
                }
            }

            @Override
            public Component getComponent() {
                return (Component)viewer.get();
            }

            @Override
            public DatabaseModificationKind[] getRelevantModifications() {
                return viewer.getRelevantModifications();
            }

            @Override
            public void update(Set<DatabaseModificationKind> observedModifications) {
                viewer.update(observedModifications);
            }
        };
    }

    private static HashMap<String, QueryParameterValue> extractFixedQueryParameters(IEntityInformationHolderWithPermId entity) {
        HashMap<String, QueryParameterValue> parameters = new HashMap<String, QueryParameterValue>();
        if (entity.getEntityKind().equals(EntityKind.MATERIAL)) {
            parameters.put(QuerySectionPanel.asParameter(KEY), new QueryParameterValue(entity.getCode(), true));
            parameters.put(QuerySectionPanel.asParameter(TYPE), new QueryParameterValue(entity.getEntityType().getCode(), true));
        } else {
            parameters.put(QuerySectionPanel.asParameter(KEY), new QueryParameterValue(entity.getPermId(), true));
        }
        return parameters;
    }

    private static String asParameter(String parameterName) {
        return PARAMETER_PREFIX + parameterName;
    }

    private static QueryType translate(EntityKind entityKind) {
        switch (entityKind) {
            case DATA_SET: {
                return QueryType.DATA_SET;
            }
            case EXPERIMENT: {
                return QueryType.EXPERIMENT;
            }
            case MATERIAL: {
                return QueryType.MATERIAL;
            }
            case SAMPLE: {
                return QueryType.SAMPLE;
            }
        }
        return null;
    }
}

