/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.module;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.report.ReportGeneratedCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableModelReference;
import ch.systemsx.cisd.openbis.generic.shared.basic.IReportInformationProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.IQueryClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.module.AbstractQueryProviderToolbar;
import ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.module.IQueryProvider;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryDatabase;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryParameterBindings;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Set;

public class QueryViewer
extends ContentPanel
implements IDatabaseModificationObserver,
IDisposableComponent {
    public static final String ID = "openbis_query-module_custom-query-viewer";
    private final IViewContext<IQueryClientServiceAsync> viewContext;
    private IDisposableComponent currentGridAsDisposable;
    private Component currentGridOrNull;
    private final IQueryProvider queryProvider;

    public static DatabaseModificationAwareComponent create(IViewContext<IQueryClientServiceAsync> viewContext, AbstractQueryProviderToolbar toolbar) {
        QueryViewer panel = new QueryViewer(viewContext, toolbar);
        return new DatabaseModificationAwareComponent((Component)panel, (IDatabaseModificationObserver)panel);
    }

    public QueryViewer(IViewContext<IQueryClientServiceAsync> viewContext, AbstractQueryProviderToolbar toolBar) {
        this.viewContext = viewContext;
        this.queryProvider = toolBar;
        this.setHeaderVisible(false);
        this.setCollapsible(false);
        this.setAnimCollapse(false);
        this.setBodyBorder(true);
        this.setTopComponent((Component)toolBar);
        toolBar.setRefreshViewerAction(new IDelegatedAction(){

            @Override
            public void execute() {
                QueryViewer.this.refresh();
            }
        });
        this.setLayout((Layout)new FitLayout());
    }

    protected void onRender(Element parent, int pos) {
        super.onRender(parent, pos);
        this.refresh();
    }

    private void refresh() {
        Long queryIdOrNull = this.queryProvider.tryGetQueryId();
        String sqlQueryOrNull = this.queryProvider.tryGetSQLQuery();
        QueryDatabase queryDatabaseOrNull = this.queryProvider.tryGetQueryDatabase();
        QueryParameterBindings bindingsOrNull = this.queryProvider.tryGetQueryParameterBindings();
        if (queryIdOrNull == null && (sqlQueryOrNull == null || queryDatabaseOrNull == null)) {
            return;
        }
        IReportInformationProvider reportInformation = this.createReportInformationProvider(sqlQueryOrNull, queryIdOrNull);
        AsyncCallback<TableModelReference> callback = ReportGeneratedCallback.create(this.viewContext.getCommonViewContext(), reportInformation, reportInformation.getKey(), this.createDisplayQueryResultsAction());
        if (queryIdOrNull != null) {
            this.viewContext.getService().createQueryResultsReport(new TechId(queryIdOrNull), bindingsOrNull, callback);
        } else if (sqlQueryOrNull != null && queryDatabaseOrNull != null) {
            this.viewContext.getService().createQueryResultsReport(queryDatabaseOrNull, sqlQueryOrNull, bindingsOrNull, callback);
        }
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return this.queryProvider.getRelevantModifications();
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.queryProvider.update(observedModifications);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void dispose() {
        if (this.currentGridAsDisposable != null) {
            this.currentGridAsDisposable.dispose();
        }
    }

    private IReportInformationProvider createReportInformationProvider(final String sqlQuery, final Long queryIdOrNull) {
        return new IReportInformationProvider(){

            @Override
            public String getDownloadURL() {
                return null;
            }

            @Override
            public String getKey() {
                if (queryIdOrNull != null) {
                    return queryIdOrNull.toString();
                }
                if (sqlQuery == null) {
                    return "null";
                }
                return Integer.toString(sqlQuery.hashCode());
            }
        };
    }

    private ReportGeneratedCallback.IOnReportComponentGeneratedAction createDisplayQueryResultsAction() {
        return new ReportGeneratedCallback.IOnReportComponentGeneratedAction(){

            @Override
            public void execute(IDisposableComponent reportComponent) {
                if (QueryViewer.this.currentGridOrNull != null) {
                    QueryViewer.this.remove(QueryViewer.this.currentGridOrNull);
                    QueryViewer.this.dispose();
                }
                QueryViewer.this.currentGridAsDisposable = reportComponent;
                QueryViewer.this.currentGridOrNull = reportComponent.getComponent();
                QueryViewer.this.add(QueryViewer.this.currentGridOrNull);
                QueryViewer.this.layout();
            }
        };
    }
}

