/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.SimpleYesNoRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.QueryType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import ch.systemsx.cisd.openbis.plugin.query.shared.IQueryServer;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryExpression;
import java.util.List;

public class QueryExpressionProvider
extends AbstractTableModelProvider<QueryExpression> {
    private final IQueryServer server;
    private final String sessionToken;

    public QueryExpressionProvider(IQueryServer server, String sessionToken) {
        this.server = server;
        this.sessionToken = sessionToken;
    }

    @Override
    protected TypedTableModel<QueryExpression> createTableModel() {
        List<QueryExpression> expressions = this.server.listQueries(this.sessionToken, QueryType.UNSPECIFIED, BasicEntityType.UNSPECIFIED);
        TypedTableModelBuilder<QueryExpression> builder = new TypedTableModelBuilder<QueryExpression>();
        builder.addColumn("NAME");
        builder.addColumn("DESCRIPTION");
        builder.addColumn("SQL_QUERY").hideByDefault();
        builder.addColumn("IS_PUBLIC").hideByDefault();
        builder.addColumn("QUERY_TYPE").hideByDefault();
        builder.addColumn("ENTITY_TYPE").hideByDefault();
        builder.addColumn("QUERY_DATABASE").hideByDefault();
        builder.addColumn("REGISTRATOR").hideByDefault();
        builder.addColumn("REGISTRATION_DATE").withDefaultWidth(300).hideByDefault();
        builder.addColumn("MODIFICATION_DATE").withDefaultWidth(300).hideByDefault();
        for (QueryExpression expression : expressions) {
            builder.addRow(expression);
            builder.column("NAME").addString(expression.getName());
            builder.column("DESCRIPTION").addString(expression.getDescription());
            builder.column("SQL_QUERY").addString(expression.getExpression());
            builder.column("IS_PUBLIC").addString(SimpleYesNoRenderer.render(expression.isPublic()));
            builder.column("QUERY_TYPE").addString(expression.getQueryType().name());
            builder.column("ENTITY_TYPE").addString(expression.getEntityTypeCode());
            builder.column("QUERY_DATABASE").addString(expression.getQueryDatabaseLabel());
            builder.column("REGISTRATOR").addPerson(expression.getRegistrator());
            builder.column("REGISTRATION_DATE").addDate(expression.getRegistrationDate());
            builder.column("MODIFICATION_DATE").addDate(expression.getModificationDate());
        }
        return builder.getModel();
    }
}

