/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.server.authorization;

import ch.systemsx.cisd.openbis.generic.server.authorization.DefaultAccessController;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.IAuthorizationChecker;
import java.util.List;
import java.util.Set;

public class AuthorizationChecker
implements IAuthorizationChecker {
    @Override
    public boolean isAuthorized(PersonPE person, SpacePE dataSpaceOrNull, RoleWithHierarchy minimalRole) {
        Set<RoleWithHierarchy> requiredRoles = minimalRole.getRoles();
        if (person != null) {
            List<RoleWithIdentifier> userRoles = DefaultAccessController.getUserRoles(person);
            DefaultAccessController.retainMatchingRoleWithIdentifiers(userRoles, requiredRoles);
            if (userRoles.size() > 0) {
                if (dataSpaceOrNull == null) {
                    return true;
                }
                return AuthorizationChecker.isSpaceMatching(userRoles, dataSpaceOrNull);
            }
            return false;
        }
        return false;
    }

    private static boolean isSpaceMatching(List<RoleWithIdentifier> userRoles, SpacePE requiredSpace) {
        for (RoleWithIdentifier role : userRoles) {
            RoleWithHierarchy.RoleLevel roleGroup = role.getRoleLevel();
            if (roleGroup.equals(RoleWithHierarchy.RoleLevel.SPACE) && role.getAssignedSpace().equals(requiredSpace)) {
                return true;
            }
            if (!roleGroup.equals(RoleWithHierarchy.RoleLevel.INSTANCE) || !role.getAssignedDatabaseInstance().equals(requiredSpace.getDatabaseInstance())) continue;
            return true;
        }
        return false;
    }
}

