/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.DisposableEntityChooser;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICriteriaProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.material.MaterialBrowserGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.material.MaterialBrowserToolbar;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListMaterialDisplayCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ClientPluginFactory;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;

public class ExperimentWellMaterialBrowserGrid
extends MaterialBrowserGrid {
    private final IViewContext<IScreeningClientServiceAsync> screeningViewContext;
    private final IEntityInformationHolderWithIdentifier experiment;

    public static DisposableEntityChooser<TableModelRowWithObject<Material>> createForExperiment(IViewContext<IScreeningClientServiceAsync> screeningViewContext, IEntityInformationHolderWithIdentifier experiment) {
        MaterialBrowserToolbar toolbar;
        MaterialBrowserToolbar criteriaProvider = toolbar = new MaterialBrowserToolbar(screeningViewContext.getCommonViewContext(), null, "experiment-well-material-browser-toolbar");
        ExperimentWellMaterialBrowserGrid browserGrid = ExperimentWellMaterialBrowserGrid.createBrowserGrid(screeningViewContext, criteriaProvider, experiment);
        browserGrid.addGridRefreshListener(toolbar);
        browserGrid.extendBottomToolbar(true);
        return browserGrid.asDisposableWithToolbar(toolbar);
    }

    private static ExperimentWellMaterialBrowserGrid createBrowserGrid(IViewContext<IScreeningClientServiceAsync> screeningViewContext, ICriteriaProvider<ListMaterialDisplayCriteria> criteriaProvider, IEntityInformationHolderWithIdentifier experiment) {
        return new ExperimentWellMaterialBrowserGrid(screeningViewContext, true, criteriaProvider, experiment);
    }

    protected ExperimentWellMaterialBrowserGrid(IViewContext<IScreeningClientServiceAsync> screeningViewContext, boolean refreshAutomatically, ICriteriaProvider<ListMaterialDisplayCriteria> criteriaProvider, IEntityInformationHolderWithIdentifier experiment) {
        super(screeningViewContext.getCommonViewContext(), refreshAutomatically, criteriaProvider);
        this.screeningViewContext = screeningViewContext;
        this.experiment = experiment;
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<Material>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<Material>> callback) {
        ListMaterialDisplayCriteria criteria = (ListMaterialDisplayCriteria)this.criteriaProvider.tryGetCriteria();
        if (criteria == null) {
            this.satisfyCallbackWithEmptyResultSet(callback);
        } else {
            criteria.copyPagingConfig(resultSetConfig);
            this.screeningViewContext.getService().listExperimentMaterials(TechId.create(this.experiment), criteria, callback);
        }
    }

    @Override
    protected void showEntityViewer(Material material, boolean editMode, boolean active) {
        if (!editMode) {
            ClientPluginFactory.openImagingMaterialViewer(material, this.createExperimentSearchCriteria(), WellSearchCriteria.AnalysisProcedureCriteria.createNoProcedures(), false, this.screeningViewContext);
        } else {
            super.showEntityViewer(material, editMode, active);
        }
    }

    private WellSearchCriteria.ExperimentSearchCriteria createExperimentSearchCriteria() {
        return WellSearchCriteria.ExperimentSearchCriteria.createExperiment(this.experiment);
    }
}

