/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.TabContent;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningViewContext;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.LogicalImageLayouter;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.LayoutUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetEnrichedReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.LogicalImageInfo;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collections;

public class ImageDataSetSection
extends TabContent {
    private final AbstractExternalData dataSet;
    private final WellLocation wellLocationOrNull;
    private static final String WELL_IMAGE_SECTION_TITLE_PREFIX = "Well ";
    private static final String WELL_IMAGE_SECTION_TITLE_SUFFIX = " Images";

    public ImageDataSetSection(ScreeningViewContext viewContext, AbstractExternalData dataSet, WellLocation wellLocationOrNull) {
        super(WELL_IMAGE_SECTION_TITLE_PREFIX + (wellLocationOrNull == null ? "" : wellLocationOrNull.toWellIdString()) + WELL_IMAGE_SECTION_TITLE_SUFFIX, viewContext, dataSet);
        this.dataSet = dataSet;
        this.wellLocationOrNull = wellLocationOrNull;
        this.setIds(DisplayTypeIDGenerator.LOGICAL_IMAGE_WELL_DATASET_SECTION);
    }

    private ScreeningViewContext getViewContext() {
        return (ScreeningViewContext)this.viewContext;
    }

    @Override
    protected void showContent() {
        ScreeningViewContext context = this.getViewContext();
        this.add((Component)new Text(context.getMessage("load_in_progress", new Object[0])));
        ((IScreeningClientServiceAsync)context.getService()).getImageDatasetInfo(this.dataSet.getCode(), this.dataSet.getDataStore().getCode(), this.wellLocationOrNull, this.createDisplayImagesCallback(context));
    }

    private AsyncCallback<LogicalImageInfo> createDisplayImagesCallback(ScreeningViewContext context) {
        return new AbstractAsyncCallback<LogicalImageInfo>((IViewContext)context){

            @Override
            protected void process(LogicalImageInfo imageDataSet) {
                ImageDataSetSection.this.removeAll();
                ImageDataSetSection.this.setLayout((Layout)new RowLayout());
                ImageDataSetSection.this.setScrollMode(Style.Scroll.AUTO);
                ImageDataSetSection.this.addVisualisation(imageDataSet);
                ImageDataSetSection.this.layout();
            }
        };
    }

    private void addVisualisation(LogicalImageInfo imageDataSet) {
        RowData margins = LayoutUtils.createRowLayoutSurroundingData();
        ScreeningViewContext context = this.getViewContext();
        LogicalImageLayouter logicalImageLayouter = new LogicalImageLayouter(context, this.wellLocationOrNull, Collections.singletonList(imageDataSet));
        ImageDatasetEnrichedReference firstImageDataset = imageDataSet.getImageDataset();
        logicalImageLayouter.changeDisplayedImageDataset(firstImageDataset);
        this.add((Widget)logicalImageLayouter, (LayoutData)margins);
    }
}

