/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.TabContent;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningViewContext;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.ImagingDatasetGuiUtils;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.LogicalImageLayouter;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.LayoutUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetEnrichedReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageSampleContent;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.LogicalImageInfo;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

public class ImageSampleSection
extends TabContent {
    private static final String NO_IMAGES_DATASET_LABEL = "No images data has been acquired.";
    private static final String WELL_IMAGE_SECTION_TITLE_SUFFIX = "Images";
    private static final String WELL_IMAGE_SECTION_TITLE_PREFIX = "Well";
    private final TechId sampleId;
    private final WellLocation wellLocationOrNull;
    private final boolean isWell;

    private static String getTabName(boolean isWell, WellLocation wellLocationOrNull) {
        if (!isWell && wellLocationOrNull != null) {
            return "Well " + wellLocationOrNull.toWellIdString() + " " + WELL_IMAGE_SECTION_TITLE_SUFFIX;
        }
        return WELL_IMAGE_SECTION_TITLE_SUFFIX;
    }

    public ImageSampleSection(ScreeningViewContext viewContext, TechId sampleId, WellLocation wellLocationOrNull, boolean isWell) {
        super(ImageSampleSection.getTabName(isWell, wellLocationOrNull), viewContext, sampleId);
        this.sampleId = sampleId;
        this.wellLocationOrNull = wellLocationOrNull;
        this.isWell = isWell;
        this.setIds(DisplayTypeIDGenerator.LOGICAL_IMAGE_WELL_SECTION);
    }

    private ScreeningViewContext getViewContext() {
        return (ScreeningViewContext)this.viewContext;
    }

    @Override
    protected void showContent() {
        ScreeningViewContext context = this.getViewContext();
        this.add((Component)new Text(context.getMessage("load_in_progress", new Object[0])));
        ((IScreeningClientServiceAsync)context.getService()).getImageDatasetInfosForSample(this.sampleId, this.isWell ? this.wellLocationOrNull : null, this.createDisplayImagesCallback(context));
    }

    private AsyncCallback<ImageSampleContent> createDisplayImagesCallback(ScreeningViewContext context) {
        return new AbstractAsyncCallback<ImageSampleContent>((IViewContext)context){

            @Override
            protected void process(ImageSampleContent imageSampleContent) {
                ImageSampleSection.this.removeAll();
                ImageSampleSection.this.setLayout((Layout)new RowLayout());
                ImageSampleSection.this.setScrollMode(Style.Scroll.AUTO);
                ImageSampleSection.this.addVisualisation(imageSampleContent);
                ImageSampleSection.this.addUnknownDatasetLinks(imageSampleContent.getUnknownDatasets());
                ImageSampleSection.this.layout();
            }
        };
    }

    private void addUnknownDatasetLinks(List<DatasetReference> unknownDatasets) {
        ImagingDatasetGuiUtils guiUtils = new ImagingDatasetGuiUtils(this.getViewContext());
        Widget w = guiUtils.tryCreateUnknownDatasetsLinks(unknownDatasets);
        if (w != null) {
            this.add(w, (LayoutData)LayoutUtils.createRowLayoutSurroundingData());
        }
    }

    private void addVisualisation(ImageSampleContent imageSampleContent) {
        RowData margins = LayoutUtils.createRowLayoutSurroundingData();
        List<LogicalImageInfo> images = imageSampleContent.getLogicalImages();
        if (images.size() == 0) {
            this.add((Widget)new Text(NO_IMAGES_DATASET_LABEL), (LayoutData)margins);
        } else {
            ScreeningViewContext context = this.getViewContext();
            LogicalImageLayouter logicalImageLayouter = new LogicalImageLayouter(context, this.wellLocationOrNull, images);
            ImageDatasetEnrichedReference viewedImageDataSet = context.tryCurrentlyViewedPlateDataSet(this.sampleId.getId());
            ImageDatasetEnrichedReference currentImageDataSet = images.get(0).getImageDataset();
            ArrayList<ImageDatasetEnrichedReference> list = new ArrayList<ImageDatasetEnrichedReference>();
            if (viewedImageDataSet != null) {
                for (LogicalImageInfo imageInfos : images) {
                    ImageDatasetEnrichedReference ref = imageInfos.getImageDataset();
                    if (ref.getId().equals(viewedImageDataSet.getId())) {
                        currentImageDataSet = ref;
                        continue;
                    }
                    list.add(ref);
                }
            }
            list.add(0, currentImageDataSet);
            Widget imageDatasetsDetails = new ImagingDatasetGuiUtils(context).createImageDatasetDetailsRow(list, logicalImageLayouter);
            logicalImageLayouter.changeDisplayedImageDataset(currentImageDataSet);
            this.add(imageDatasetsDetails, (LayoutData)margins);
            this.add((Widget)logicalImageLayouter, (LayoutData)margins);
        }
    }
}

